/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.fluent.models.DedicatedHostGroupProperties;
import com.azure.resourcemanager.compute.models.DedicatedHostGroupInstanceView;
import com.azure.resourcemanager.compute.models.DedicatedHostGroupPropertiesAdditionalCapabilities;
import com.azure.resourcemanager.compute.models.SubResourceReadOnly;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class DedicatedHostGroupInner
extends Resource {
    private DedicatedHostGroupProperties innerProperties;
    private List<String> zones;
    private SystemData systemData;
    private String type;
    private String name;
    private String id;

    private DedicatedHostGroupProperties innerProperties() {
        return this.innerProperties;
    }

    public List<String> zones() {
        return this.zones;
    }

    public DedicatedHostGroupInner withZones(List<String> zones) {
        this.zones = zones;
        return this;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public DedicatedHostGroupInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public DedicatedHostGroupInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public Integer platformFaultDomainCount() {
        return this.innerProperties() == null ? null : Integer.valueOf(this.innerProperties().platformFaultDomainCount());
    }

    public DedicatedHostGroupInner withPlatformFaultDomainCount(Integer platformFaultDomainCount) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DedicatedHostGroupProperties();
        }
        this.innerProperties().withPlatformFaultDomainCount(platformFaultDomainCount);
        return this;
    }

    public List<SubResourceReadOnly> hosts() {
        return this.innerProperties() == null ? null : this.innerProperties().hosts();
    }

    public DedicatedHostGroupInstanceView instanceView() {
        return this.innerProperties() == null ? null : this.innerProperties().instanceView();
    }

    public Boolean supportAutomaticPlacement() {
        return this.innerProperties() == null ? null : this.innerProperties().supportAutomaticPlacement();
    }

    public DedicatedHostGroupInner withSupportAutomaticPlacement(Boolean supportAutomaticPlacement) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DedicatedHostGroupProperties();
        }
        this.innerProperties().withSupportAutomaticPlacement(supportAutomaticPlacement);
        return this;
    }

    public DedicatedHostGroupPropertiesAdditionalCapabilities additionalCapabilities() {
        return this.innerProperties() == null ? null : this.innerProperties().additionalCapabilities();
    }

    public DedicatedHostGroupInner withAdditionalCapabilities(DedicatedHostGroupPropertiesAdditionalCapabilities additionalCapabilities) {
        if (this.innerProperties() == null) {
            this.innerProperties = new DedicatedHostGroupProperties();
        }
        this.innerProperties().withAdditionalCapabilities(additionalCapabilities);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        jsonWriter.writeArrayField("zones", this.zones, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static DedicatedHostGroupInner fromJson(JsonReader jsonReader) throws IOException {
        return (DedicatedHostGroupInner)((Object)jsonReader.readObject(reader -> {
            DedicatedHostGroupInner deserializedDedicatedHostGroupInner = new DedicatedHostGroupInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedDedicatedHostGroupInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedDedicatedHostGroupInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedDedicatedHostGroupInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedDedicatedHostGroupInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedDedicatedHostGroupInner.withTags(tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedDedicatedHostGroupInner.innerProperties = DedicatedHostGroupProperties.fromJson(reader);
                    continue;
                }
                if ("zones".equals(fieldName)) {
                    List zones;
                    deserializedDedicatedHostGroupInner.zones = zones = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedDedicatedHostGroupInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDedicatedHostGroupInner;
        }));
    }
}

