/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.fluent.models.ResourceSkuInner;
import java.io.IOException;
import java.util.List;

public final class ResourceSkusResult
implements JsonSerializable<ResourceSkusResult> {
    private List<ResourceSkuInner> value;
    private String nextLink;
    private static final ClientLogger LOGGER = new ClientLogger(ResourceSkusResult.class);

    public List<ResourceSkuInner> value() {
        return this.value;
    }

    public ResourceSkusResult withValue(List<ResourceSkuInner> value) {
        this.value = value;
        return this;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public ResourceSkusResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    public void validate() {
        if (this.value() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property value in model ResourceSkusResult"));
        }
        this.value().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    public static ResourceSkusResult fromJson(JsonReader jsonReader) throws IOException {
        return (ResourceSkusResult)jsonReader.readObject(reader -> {
            ResourceSkusResult deserializedResourceSkusResult = new ResourceSkusResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedResourceSkusResult.value = value = reader.readArray(reader1 -> ResourceSkuInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedResourceSkusResult.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedResourceSkusResult;
        });
    }
}

