/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.fluent.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.management.Resource;
import com.azure.core.management.SubResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.compute.fluent.models.VirtualMachineExtensionInner;
import com.azure.resourcemanager.compute.fluent.models.VirtualMachineInstanceViewInner;
import com.azure.resourcemanager.compute.models.AdditionalCapabilities;
import com.azure.resourcemanager.compute.models.BillingProfile;
import com.azure.resourcemanager.compute.models.DiagnosticsProfile;
import com.azure.resourcemanager.compute.models.ExtendedLocation;
import com.azure.resourcemanager.compute.models.HardwareProfile;
import com.azure.resourcemanager.compute.models.NetworkProfile;
import com.azure.resourcemanager.compute.models.OSProfile;
import com.azure.resourcemanager.compute.models.Plan;
import com.azure.resourcemanager.compute.models.ScheduledEventsProfile;
import com.azure.resourcemanager.compute.models.SecurityProfile;
import com.azure.resourcemanager.compute.models.StorageProfile;
import com.azure.resourcemanager.compute.models.VirtualMachineEvictionPolicyTypes;
import com.azure.resourcemanager.compute.models.VirtualMachineIdentity;
import com.azure.resourcemanager.compute.models.VirtualMachinePriorityTypes;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

@JsonFlatten
public class VirtualMachineInner
extends Resource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(VirtualMachineInner.class);
    @JsonProperty(value="plan")
    private Plan plan;
    @JsonProperty(value="resources", access=JsonProperty.Access.WRITE_ONLY)
    private List<VirtualMachineExtensionInner> resources;
    @JsonProperty(value="identity")
    private VirtualMachineIdentity identity;
    @JsonProperty(value="zones")
    private List<String> zones;
    @JsonProperty(value="extendedLocation")
    private ExtendedLocation extendedLocation;
    @JsonProperty(value="properties.hardwareProfile")
    private HardwareProfile hardwareProfile;
    @JsonProperty(value="properties.storageProfile")
    private StorageProfile storageProfile;
    @JsonProperty(value="properties.additionalCapabilities")
    private AdditionalCapabilities additionalCapabilities;
    @JsonProperty(value="properties.osProfile")
    private OSProfile osProfile;
    @JsonProperty(value="properties.networkProfile")
    private NetworkProfile networkProfile;
    @JsonProperty(value="properties.securityProfile")
    private SecurityProfile securityProfile;
    @JsonProperty(value="properties.diagnosticsProfile")
    private DiagnosticsProfile diagnosticsProfile;
    @JsonProperty(value="properties.availabilitySet")
    private SubResource availabilitySet;
    @JsonProperty(value="properties.virtualMachineScaleSet")
    private SubResource virtualMachineScaleSet;
    @JsonProperty(value="properties.proximityPlacementGroup")
    private SubResource proximityPlacementGroup;
    @JsonProperty(value="properties.priority")
    private VirtualMachinePriorityTypes priority;
    @JsonProperty(value="properties.evictionPolicy")
    private VirtualMachineEvictionPolicyTypes evictionPolicy;
    @JsonProperty(value="properties.billingProfile")
    private BillingProfile billingProfile;
    @JsonProperty(value="properties.host")
    private SubResource host;
    @JsonProperty(value="properties.hostGroup")
    private SubResource hostGroup;
    @JsonProperty(value="properties.provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private String provisioningState;
    @JsonProperty(value="properties.instanceView", access=JsonProperty.Access.WRITE_ONLY)
    private VirtualMachineInstanceViewInner instanceView;
    @JsonProperty(value="properties.licenseType")
    private String licenseType;
    @JsonProperty(value="properties.vmId", access=JsonProperty.Access.WRITE_ONLY)
    private String vmId;
    @JsonProperty(value="properties.extensionsTimeBudget")
    private String extensionsTimeBudget;
    @JsonProperty(value="properties.platformFaultDomain")
    private Integer platformFaultDomain;
    @JsonProperty(value="properties.scheduledEventsProfile")
    private ScheduledEventsProfile scheduledEventsProfile;
    @JsonProperty(value="properties.userData")
    private String userData;

    public Plan plan() {
        return this.plan;
    }

    public VirtualMachineInner withPlan(Plan plan) {
        this.plan = plan;
        return this;
    }

    public List<VirtualMachineExtensionInner> resources() {
        return this.resources;
    }

    public VirtualMachineIdentity identity() {
        return this.identity;
    }

    public VirtualMachineInner withIdentity(VirtualMachineIdentity identity) {
        this.identity = identity;
        return this;
    }

    public List<String> zones() {
        return this.zones;
    }

    public VirtualMachineInner withZones(List<String> zones) {
        this.zones = zones;
        return this;
    }

    public ExtendedLocation extendedLocation() {
        return this.extendedLocation;
    }

    public VirtualMachineInner withExtendedLocation(ExtendedLocation extendedLocation) {
        this.extendedLocation = extendedLocation;
        return this;
    }

    public HardwareProfile hardwareProfile() {
        return this.hardwareProfile;
    }

    public VirtualMachineInner withHardwareProfile(HardwareProfile hardwareProfile) {
        this.hardwareProfile = hardwareProfile;
        return this;
    }

    public StorageProfile storageProfile() {
        return this.storageProfile;
    }

    public VirtualMachineInner withStorageProfile(StorageProfile storageProfile) {
        this.storageProfile = storageProfile;
        return this;
    }

    public AdditionalCapabilities additionalCapabilities() {
        return this.additionalCapabilities;
    }

    public VirtualMachineInner withAdditionalCapabilities(AdditionalCapabilities additionalCapabilities) {
        this.additionalCapabilities = additionalCapabilities;
        return this;
    }

    public OSProfile osProfile() {
        return this.osProfile;
    }

    public VirtualMachineInner withOsProfile(OSProfile osProfile) {
        this.osProfile = osProfile;
        return this;
    }

    public NetworkProfile networkProfile() {
        return this.networkProfile;
    }

    public VirtualMachineInner withNetworkProfile(NetworkProfile networkProfile) {
        this.networkProfile = networkProfile;
        return this;
    }

    public SecurityProfile securityProfile() {
        return this.securityProfile;
    }

    public VirtualMachineInner withSecurityProfile(SecurityProfile securityProfile) {
        this.securityProfile = securityProfile;
        return this;
    }

    public DiagnosticsProfile diagnosticsProfile() {
        return this.diagnosticsProfile;
    }

    public VirtualMachineInner withDiagnosticsProfile(DiagnosticsProfile diagnosticsProfile) {
        this.diagnosticsProfile = diagnosticsProfile;
        return this;
    }

    public SubResource availabilitySet() {
        return this.availabilitySet;
    }

    public VirtualMachineInner withAvailabilitySet(SubResource availabilitySet) {
        this.availabilitySet = availabilitySet;
        return this;
    }

    public SubResource virtualMachineScaleSet() {
        return this.virtualMachineScaleSet;
    }

    public VirtualMachineInner withVirtualMachineScaleSet(SubResource virtualMachineScaleSet) {
        this.virtualMachineScaleSet = virtualMachineScaleSet;
        return this;
    }

    public SubResource proximityPlacementGroup() {
        return this.proximityPlacementGroup;
    }

    public VirtualMachineInner withProximityPlacementGroup(SubResource proximityPlacementGroup) {
        this.proximityPlacementGroup = proximityPlacementGroup;
        return this;
    }

    public VirtualMachinePriorityTypes priority() {
        return this.priority;
    }

    public VirtualMachineInner withPriority(VirtualMachinePriorityTypes priority) {
        this.priority = priority;
        return this;
    }

    public VirtualMachineEvictionPolicyTypes evictionPolicy() {
        return this.evictionPolicy;
    }

    public VirtualMachineInner withEvictionPolicy(VirtualMachineEvictionPolicyTypes evictionPolicy) {
        this.evictionPolicy = evictionPolicy;
        return this;
    }

    public BillingProfile billingProfile() {
        return this.billingProfile;
    }

    public VirtualMachineInner withBillingProfile(BillingProfile billingProfile) {
        this.billingProfile = billingProfile;
        return this;
    }

    public SubResource host() {
        return this.host;
    }

    public VirtualMachineInner withHost(SubResource host) {
        this.host = host;
        return this;
    }

    public SubResource hostGroup() {
        return this.hostGroup;
    }

    public VirtualMachineInner withHostGroup(SubResource hostGroup) {
        this.hostGroup = hostGroup;
        return this;
    }

    public String provisioningState() {
        return this.provisioningState;
    }

    public VirtualMachineInstanceViewInner instanceView() {
        return this.instanceView;
    }

    public String licenseType() {
        return this.licenseType;
    }

    public VirtualMachineInner withLicenseType(String licenseType) {
        this.licenseType = licenseType;
        return this;
    }

    public String vmId() {
        return this.vmId;
    }

    public String extensionsTimeBudget() {
        return this.extensionsTimeBudget;
    }

    public VirtualMachineInner withExtensionsTimeBudget(String extensionsTimeBudget) {
        this.extensionsTimeBudget = extensionsTimeBudget;
        return this;
    }

    public Integer platformFaultDomain() {
        return this.platformFaultDomain;
    }

    public VirtualMachineInner withPlatformFaultDomain(Integer platformFaultDomain) {
        this.platformFaultDomain = platformFaultDomain;
        return this;
    }

    public ScheduledEventsProfile scheduledEventsProfile() {
        return this.scheduledEventsProfile;
    }

    public VirtualMachineInner withScheduledEventsProfile(ScheduledEventsProfile scheduledEventsProfile) {
        this.scheduledEventsProfile = scheduledEventsProfile;
        return this;
    }

    public String userData() {
        return this.userData;
    }

    public VirtualMachineInner withUserData(String userData) {
        this.userData = userData;
        return this;
    }

    public VirtualMachineInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public VirtualMachineInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public void validate() {
        if (this.plan() != null) {
            this.plan().validate();
        }
        if (this.resources() != null) {
            this.resources().forEach(e -> e.validate());
        }
        if (this.identity() != null) {
            this.identity().validate();
        }
        if (this.extendedLocation() != null) {
            this.extendedLocation().validate();
        }
        if (this.hardwareProfile() != null) {
            this.hardwareProfile().validate();
        }
        if (this.storageProfile() != null) {
            this.storageProfile().validate();
        }
        if (this.additionalCapabilities() != null) {
            this.additionalCapabilities().validate();
        }
        if (this.osProfile() != null) {
            this.osProfile().validate();
        }
        if (this.networkProfile() != null) {
            this.networkProfile().validate();
        }
        if (this.securityProfile() != null) {
            this.securityProfile().validate();
        }
        if (this.diagnosticsProfile() != null) {
            this.diagnosticsProfile().validate();
        }
        if (this.billingProfile() != null) {
            this.billingProfile().validate();
        }
        if (this.instanceView() != null) {
            this.instanceView().validate();
        }
        if (this.scheduledEventsProfile() != null) {
            this.scheduledEventsProfile().validate();
        }
    }
}

