/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.compute.fluent.VirtualMachineScaleSetVMExtensionsClient;
import com.azure.resourcemanager.compute.fluent.models.VirtualMachineScaleSetVMExtensionInner;
import com.azure.resourcemanager.compute.fluent.models.VirtualMachineScaleSetVMExtensionsListResultInner;
import com.azure.resourcemanager.compute.implementation.ComputeManagementClientImpl;
import com.azure.resourcemanager.compute.models.ApiErrorException;
import com.azure.resourcemanager.compute.models.VirtualMachineScaleSetVMExtensionUpdate;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class VirtualMachineScaleSetVMExtensionsClientImpl
implements VirtualMachineScaleSetVMExtensionsClient {
    private final ClientLogger logger = new ClientLogger(VirtualMachineScaleSetVMExtensionsClientImpl.class);
    private final VirtualMachineScaleSetVMExtensionsService service;
    private final ComputeManagementClientImpl client;

    VirtualMachineScaleSetVMExtensionsClientImpl(ComputeManagementClientImpl client) {
        this.service = (VirtualMachineScaleSetVMExtensionsService)RestProxy.create(VirtualMachineScaleSetVMExtensionsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String vmScaleSetName, String instanceId, String vmExtensionName, VirtualMachineScaleSetVMExtensionInner extensionParameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vmScaleSetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vmScaleSetName is required and cannot be null."));
        }
        if (instanceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter instanceId is required and cannot be null."));
        }
        if (vmExtensionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vmExtensionName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (extensionParameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter extensionParameters is required and cannot be null."));
        }
        extensionParameters.validate();
        String apiVersion = "2021-03-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), resourceGroupName, vmScaleSetName, instanceId, vmExtensionName, "2021-03-01", this.client.getSubscriptionId(), extensionParameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String vmScaleSetName, String instanceId, String vmExtensionName, VirtualMachineScaleSetVMExtensionInner extensionParameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vmScaleSetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vmScaleSetName is required and cannot be null."));
        }
        if (instanceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter instanceId is required and cannot be null."));
        }
        if (vmExtensionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vmExtensionName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (extensionParameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter extensionParameters is required and cannot be null."));
        }
        extensionParameters.validate();
        String apiVersion = "2021-03-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdate(this.client.getEndpoint(), resourceGroupName, vmScaleSetName, instanceId, vmExtensionName, "2021-03-01", this.client.getSubscriptionId(), extensionParameters, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public PollerFlux<PollResult<VirtualMachineScaleSetVMExtensionInner>, VirtualMachineScaleSetVMExtensionInner> beginCreateOrUpdateAsync(String resourceGroupName, String vmScaleSetName, String instanceId, String vmExtensionName, VirtualMachineScaleSetVMExtensionInner extensionParameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, vmScaleSetName, instanceId, vmExtensionName, extensionParameters);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)VirtualMachineScaleSetVMExtensionInner.class), (Type)((Object)VirtualMachineScaleSetVMExtensionInner.class), Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PollerFlux<PollResult<VirtualMachineScaleSetVMExtensionInner>, VirtualMachineScaleSetVMExtensionInner> beginCreateOrUpdateAsync(String resourceGroupName, String vmScaleSetName, String instanceId, String vmExtensionName, VirtualMachineScaleSetVMExtensionInner extensionParameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, vmScaleSetName, instanceId, vmExtensionName, extensionParameters, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)VirtualMachineScaleSetVMExtensionInner.class), (Type)((Object)VirtualMachineScaleSetVMExtensionInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SyncPoller<PollResult<VirtualMachineScaleSetVMExtensionInner>, VirtualMachineScaleSetVMExtensionInner> beginCreateOrUpdate(String resourceGroupName, String vmScaleSetName, String instanceId, String vmExtensionName, VirtualMachineScaleSetVMExtensionInner extensionParameters) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, vmScaleSetName, instanceId, vmExtensionName, extensionParameters).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SyncPoller<PollResult<VirtualMachineScaleSetVMExtensionInner>, VirtualMachineScaleSetVMExtensionInner> beginCreateOrUpdate(String resourceGroupName, String vmScaleSetName, String instanceId, String vmExtensionName, VirtualMachineScaleSetVMExtensionInner extensionParameters, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, vmScaleSetName, instanceId, vmExtensionName, extensionParameters, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<VirtualMachineScaleSetVMExtensionInner> createOrUpdateAsync(String resourceGroupName, String vmScaleSetName, String instanceId, String vmExtensionName, VirtualMachineScaleSetVMExtensionInner extensionParameters) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, vmScaleSetName, instanceId, vmExtensionName, extensionParameters).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<VirtualMachineScaleSetVMExtensionInner> createOrUpdateAsync(String resourceGroupName, String vmScaleSetName, String instanceId, String vmExtensionName, VirtualMachineScaleSetVMExtensionInner extensionParameters, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, vmScaleSetName, instanceId, vmExtensionName, extensionParameters, context).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public VirtualMachineScaleSetVMExtensionInner createOrUpdate(String resourceGroupName, String vmScaleSetName, String instanceId, String vmExtensionName, VirtualMachineScaleSetVMExtensionInner extensionParameters) {
        return (VirtualMachineScaleSetVMExtensionInner)this.createOrUpdateAsync(resourceGroupName, vmScaleSetName, instanceId, vmExtensionName, extensionParameters).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public VirtualMachineScaleSetVMExtensionInner createOrUpdate(String resourceGroupName, String vmScaleSetName, String instanceId, String vmExtensionName, VirtualMachineScaleSetVMExtensionInner extensionParameters, Context context) {
        return (VirtualMachineScaleSetVMExtensionInner)this.createOrUpdateAsync(resourceGroupName, vmScaleSetName, instanceId, vmExtensionName, extensionParameters, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String vmScaleSetName, String instanceId, String vmExtensionName, VirtualMachineScaleSetVMExtensionUpdate extensionParameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vmScaleSetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vmScaleSetName is required and cannot be null."));
        }
        if (instanceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter instanceId is required and cannot be null."));
        }
        if (vmExtensionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vmExtensionName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (extensionParameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter extensionParameters is required and cannot be null."));
        }
        extensionParameters.validate();
        String apiVersion = "2021-03-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.update(this.client.getEndpoint(), resourceGroupName, vmScaleSetName, instanceId, vmExtensionName, "2021-03-01", this.client.getSubscriptionId(), extensionParameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String vmScaleSetName, String instanceId, String vmExtensionName, VirtualMachineScaleSetVMExtensionUpdate extensionParameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vmScaleSetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vmScaleSetName is required and cannot be null."));
        }
        if (instanceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter instanceId is required and cannot be null."));
        }
        if (vmExtensionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vmExtensionName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (extensionParameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter extensionParameters is required and cannot be null."));
        }
        extensionParameters.validate();
        String apiVersion = "2021-03-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.update(this.client.getEndpoint(), resourceGroupName, vmScaleSetName, instanceId, vmExtensionName, "2021-03-01", this.client.getSubscriptionId(), extensionParameters, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public PollerFlux<PollResult<VirtualMachineScaleSetVMExtensionInner>, VirtualMachineScaleSetVMExtensionInner> beginUpdateAsync(String resourceGroupName, String vmScaleSetName, String instanceId, String vmExtensionName, VirtualMachineScaleSetVMExtensionUpdate extensionParameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, vmScaleSetName, instanceId, vmExtensionName, extensionParameters);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)VirtualMachineScaleSetVMExtensionInner.class), (Type)((Object)VirtualMachineScaleSetVMExtensionInner.class), Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PollerFlux<PollResult<VirtualMachineScaleSetVMExtensionInner>, VirtualMachineScaleSetVMExtensionInner> beginUpdateAsync(String resourceGroupName, String vmScaleSetName, String instanceId, String vmExtensionName, VirtualMachineScaleSetVMExtensionUpdate extensionParameters, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, vmScaleSetName, instanceId, vmExtensionName, extensionParameters, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)VirtualMachineScaleSetVMExtensionInner.class), (Type)((Object)VirtualMachineScaleSetVMExtensionInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SyncPoller<PollResult<VirtualMachineScaleSetVMExtensionInner>, VirtualMachineScaleSetVMExtensionInner> beginUpdate(String resourceGroupName, String vmScaleSetName, String instanceId, String vmExtensionName, VirtualMachineScaleSetVMExtensionUpdate extensionParameters) {
        return this.beginUpdateAsync(resourceGroupName, vmScaleSetName, instanceId, vmExtensionName, extensionParameters).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SyncPoller<PollResult<VirtualMachineScaleSetVMExtensionInner>, VirtualMachineScaleSetVMExtensionInner> beginUpdate(String resourceGroupName, String vmScaleSetName, String instanceId, String vmExtensionName, VirtualMachineScaleSetVMExtensionUpdate extensionParameters, Context context) {
        return this.beginUpdateAsync(resourceGroupName, vmScaleSetName, instanceId, vmExtensionName, extensionParameters, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<VirtualMachineScaleSetVMExtensionInner> updateAsync(String resourceGroupName, String vmScaleSetName, String instanceId, String vmExtensionName, VirtualMachineScaleSetVMExtensionUpdate extensionParameters) {
        return this.beginUpdateAsync(resourceGroupName, vmScaleSetName, instanceId, vmExtensionName, extensionParameters).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<VirtualMachineScaleSetVMExtensionInner> updateAsync(String resourceGroupName, String vmScaleSetName, String instanceId, String vmExtensionName, VirtualMachineScaleSetVMExtensionUpdate extensionParameters, Context context) {
        return this.beginUpdateAsync(resourceGroupName, vmScaleSetName, instanceId, vmExtensionName, extensionParameters, context).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public VirtualMachineScaleSetVMExtensionInner update(String resourceGroupName, String vmScaleSetName, String instanceId, String vmExtensionName, VirtualMachineScaleSetVMExtensionUpdate extensionParameters) {
        return (VirtualMachineScaleSetVMExtensionInner)this.updateAsync(resourceGroupName, vmScaleSetName, instanceId, vmExtensionName, extensionParameters).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public VirtualMachineScaleSetVMExtensionInner update(String resourceGroupName, String vmScaleSetName, String instanceId, String vmExtensionName, VirtualMachineScaleSetVMExtensionUpdate extensionParameters, Context context) {
        return (VirtualMachineScaleSetVMExtensionInner)this.updateAsync(resourceGroupName, vmScaleSetName, instanceId, vmExtensionName, extensionParameters, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String vmScaleSetName, String instanceId, String vmExtensionName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vmScaleSetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vmScaleSetName is required and cannot be null."));
        }
        if (instanceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter instanceId is required and cannot be null."));
        }
        if (vmExtensionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vmExtensionName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2021-03-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), resourceGroupName, vmScaleSetName, instanceId, vmExtensionName, "2021-03-01", this.client.getSubscriptionId(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String vmScaleSetName, String instanceId, String vmExtensionName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vmScaleSetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vmScaleSetName is required and cannot be null."));
        }
        if (instanceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter instanceId is required and cannot be null."));
        }
        if (vmExtensionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vmExtensionName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2021-03-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), resourceGroupName, vmScaleSetName, instanceId, vmExtensionName, "2021-03-01", this.client.getSubscriptionId(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String vmScaleSetName, String instanceId, String vmExtensionName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, vmScaleSetName, instanceId, vmExtensionName);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String vmScaleSetName, String instanceId, String vmExtensionName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, vmScaleSetName, instanceId, vmExtensionName, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String vmScaleSetName, String instanceId, String vmExtensionName) {
        return this.beginDeleteAsync(resourceGroupName, vmScaleSetName, instanceId, vmExtensionName).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String vmScaleSetName, String instanceId, String vmExtensionName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, vmScaleSetName, instanceId, vmExtensionName, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String resourceGroupName, String vmScaleSetName, String instanceId, String vmExtensionName) {
        return this.beginDeleteAsync(resourceGroupName, vmScaleSetName, instanceId, vmExtensionName).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String vmScaleSetName, String instanceId, String vmExtensionName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, vmScaleSetName, instanceId, vmExtensionName, context).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String vmScaleSetName, String instanceId, String vmExtensionName) {
        this.deleteAsync(resourceGroupName, vmScaleSetName, instanceId, vmExtensionName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String vmScaleSetName, String instanceId, String vmExtensionName, Context context) {
        this.deleteAsync(resourceGroupName, vmScaleSetName, instanceId, vmExtensionName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<VirtualMachineScaleSetVMExtensionInner>> getWithResponseAsync(String resourceGroupName, String vmScaleSetName, String instanceId, String vmExtensionName, String expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vmScaleSetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vmScaleSetName is required and cannot be null."));
        }
        if (instanceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter instanceId is required and cannot be null."));
        }
        if (vmExtensionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vmExtensionName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2021-03-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), resourceGroupName, vmScaleSetName, instanceId, vmExtensionName, expand, "2021-03-01", this.client.getSubscriptionId(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<VirtualMachineScaleSetVMExtensionInner>> getWithResponseAsync(String resourceGroupName, String vmScaleSetName, String instanceId, String vmExtensionName, String expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vmScaleSetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vmScaleSetName is required and cannot be null."));
        }
        if (instanceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter instanceId is required and cannot be null."));
        }
        if (vmExtensionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vmExtensionName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2021-03-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), resourceGroupName, vmScaleSetName, instanceId, vmExtensionName, expand, "2021-03-01", this.client.getSubscriptionId(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<VirtualMachineScaleSetVMExtensionInner> getAsync(String resourceGroupName, String vmScaleSetName, String instanceId, String vmExtensionName, String expand) {
        return this.getWithResponseAsync(resourceGroupName, vmScaleSetName, instanceId, vmExtensionName, expand).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((VirtualMachineScaleSetVMExtensionInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<VirtualMachineScaleSetVMExtensionInner> getAsync(String resourceGroupName, String vmScaleSetName, String instanceId, String vmExtensionName) {
        String expand = null;
        return this.getWithResponseAsync(resourceGroupName, vmScaleSetName, instanceId, vmExtensionName, expand).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((VirtualMachineScaleSetVMExtensionInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public VirtualMachineScaleSetVMExtensionInner get(String resourceGroupName, String vmScaleSetName, String instanceId, String vmExtensionName) {
        String expand = null;
        return (VirtualMachineScaleSetVMExtensionInner)this.getAsync(resourceGroupName, vmScaleSetName, instanceId, vmExtensionName, expand).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<VirtualMachineScaleSetVMExtensionInner> getWithResponse(String resourceGroupName, String vmScaleSetName, String instanceId, String vmExtensionName, String expand, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, vmScaleSetName, instanceId, vmExtensionName, expand, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<VirtualMachineScaleSetVMExtensionsListResultInner>> listWithResponseAsync(String resourceGroupName, String vmScaleSetName, String instanceId, String expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vmScaleSetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vmScaleSetName is required and cannot be null."));
        }
        if (instanceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter instanceId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2021-03-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), resourceGroupName, vmScaleSetName, instanceId, expand, "2021-03-01", this.client.getSubscriptionId(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<VirtualMachineScaleSetVMExtensionsListResultInner>> listWithResponseAsync(String resourceGroupName, String vmScaleSetName, String instanceId, String expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (vmScaleSetName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vmScaleSetName is required and cannot be null."));
        }
        if (instanceId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter instanceId is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String apiVersion = "2021-03-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), resourceGroupName, vmScaleSetName, instanceId, expand, "2021-03-01", this.client.getSubscriptionId(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<VirtualMachineScaleSetVMExtensionsListResultInner> listAsync(String resourceGroupName, String vmScaleSetName, String instanceId, String expand) {
        return this.listWithResponseAsync(resourceGroupName, vmScaleSetName, instanceId, expand).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((VirtualMachineScaleSetVMExtensionsListResultInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<VirtualMachineScaleSetVMExtensionsListResultInner> listAsync(String resourceGroupName, String vmScaleSetName, String instanceId) {
        String expand = null;
        return this.listWithResponseAsync(resourceGroupName, vmScaleSetName, instanceId, expand).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((VirtualMachineScaleSetVMExtensionsListResultInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public VirtualMachineScaleSetVMExtensionsListResultInner list(String resourceGroupName, String vmScaleSetName, String instanceId) {
        String expand = null;
        return (VirtualMachineScaleSetVMExtensionsListResultInner)this.listAsync(resourceGroupName, vmScaleSetName, instanceId, expand).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<VirtualMachineScaleSetVMExtensionsListResultInner> listWithResponse(String resourceGroupName, String vmScaleSetName, String instanceId, String expand, Context context) {
        return (Response)this.listWithResponseAsync(resourceGroupName, vmScaleSetName, instanceId, expand, context).block();
    }

    @Host(value="{$host}")
    @ServiceInterface(name="ComputeManagementCli")
    private static interface VirtualMachineScaleSetVMExtensionsService {
        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmScaleSetName}/virtualMachines/{instanceId}/extensions/{vmExtensionName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ApiErrorException.class)
        public Mono<Response<Flux<ByteBuffer>>> createOrUpdate(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="vmScaleSetName") String var3, @PathParam(value="instanceId") String var4, @PathParam(value="vmExtensionName") String var5, @QueryParam(value="api-version") String var6, @PathParam(value="subscriptionId") String var7, @BodyParam(value="application/json") VirtualMachineScaleSetVMExtensionInner var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmScaleSetName}/virtualMachines/{instanceId}/extensions/{vmExtensionName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ApiErrorException.class)
        public Mono<Response<Flux<ByteBuffer>>> update(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="vmScaleSetName") String var3, @PathParam(value="instanceId") String var4, @PathParam(value="vmExtensionName") String var5, @QueryParam(value="api-version") String var6, @PathParam(value="subscriptionId") String var7, @BodyParam(value="application/json") VirtualMachineScaleSetVMExtensionUpdate var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmScaleSetName}/virtualMachines/{instanceId}/extensions/{vmExtensionName}")
        @ExpectedResponses(value={200, 202, 204})
        @UnexpectedResponseExceptionType(value=ApiErrorException.class)
        public Mono<Response<Flux<ByteBuffer>>> delete(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="vmScaleSetName") String var3, @PathParam(value="instanceId") String var4, @PathParam(value="vmExtensionName") String var5, @QueryParam(value="api-version") String var6, @PathParam(value="subscriptionId") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmScaleSetName}/virtualMachines/{instanceId}/extensions/{vmExtensionName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ApiErrorException.class)
        public Mono<Response<VirtualMachineScaleSetVMExtensionInner>> get(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="vmScaleSetName") String var3, @PathParam(value="instanceId") String var4, @PathParam(value="vmExtensionName") String var5, @QueryParam(value="$expand") String var6, @QueryParam(value="api-version") String var7, @PathParam(value="subscriptionId") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/virtualMachineScaleSets/{vmScaleSetName}/virtualMachines/{instanceId}/extensions")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ApiErrorException.class)
        public Mono<Response<VirtualMachineScaleSetVMExtensionsListResultInner>> list(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="vmScaleSetName") String var3, @PathParam(value="instanceId") String var4, @QueryParam(value="$expand") String var5, @QueryParam(value="api-version") String var6, @PathParam(value="subscriptionId") String var7, @HeaderParam(value="Accept") String var8, Context var9);
    }
}

