/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.compute.fluent.models.RestorePointInner;
import com.azure.resourcemanager.compute.models.RestorePointCollectionSourceProperties;
import com.azure.resourcemanager.compute.models.UpdateResource;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

@JsonFlatten
public class RestorePointCollectionUpdate
extends UpdateResource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(RestorePointCollectionUpdate.class);
    @JsonProperty(value="properties.source")
    private RestorePointCollectionSourceProperties source;
    @JsonProperty(value="properties.provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private String provisioningState;
    @JsonProperty(value="properties.restorePointCollectionId", access=JsonProperty.Access.WRITE_ONLY)
    private String restorePointCollectionId;
    @JsonProperty(value="properties.restorePoints", access=JsonProperty.Access.WRITE_ONLY)
    private List<RestorePointInner> restorePoints;

    public RestorePointCollectionSourceProperties source() {
        return this.source;
    }

    public RestorePointCollectionUpdate withSource(RestorePointCollectionSourceProperties source) {
        this.source = source;
        return this;
    }

    public String provisioningState() {
        return this.provisioningState;
    }

    public String restorePointCollectionId() {
        return this.restorePointCollectionId;
    }

    public List<RestorePointInner> restorePoints() {
        return this.restorePoints;
    }

    @Override
    public RestorePointCollectionUpdate withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.source() != null) {
            this.source().validate();
        }
        if (this.restorePoints() != null) {
            this.restorePoints().forEach(e -> e.validate());
        }
    }
}

