/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.management.SubResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.compute.models.IpVersions;
import com.azure.resourcemanager.compute.models.VirtualMachinePublicIpAddressConfiguration;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

@JsonFlatten
public class VirtualMachineNetworkInterfaceIpConfiguration {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(VirtualMachineNetworkInterfaceIpConfiguration.class);
    @JsonProperty(value="name", required=true)
    private String name;
    @JsonProperty(value="properties.subnet")
    private SubResource subnet;
    @JsonProperty(value="properties.primary")
    private Boolean primary;
    @JsonProperty(value="properties.publicIPAddressConfiguration")
    private VirtualMachinePublicIpAddressConfiguration publicIpAddressConfiguration;
    @JsonProperty(value="properties.privateIPAddressVersion")
    private IpVersions privateIpAddressVersion;
    @JsonProperty(value="properties.applicationSecurityGroups")
    private List<SubResource> applicationSecurityGroups;
    @JsonProperty(value="properties.applicationGatewayBackendAddressPools")
    private List<SubResource> applicationGatewayBackendAddressPools;
    @JsonProperty(value="properties.loadBalancerBackendAddressPools")
    private List<SubResource> loadBalancerBackendAddressPools;

    public String name() {
        return this.name;
    }

    public VirtualMachineNetworkInterfaceIpConfiguration withName(String name) {
        this.name = name;
        return this;
    }

    public SubResource subnet() {
        return this.subnet;
    }

    public VirtualMachineNetworkInterfaceIpConfiguration withSubnet(SubResource subnet) {
        this.subnet = subnet;
        return this;
    }

    public Boolean primary() {
        return this.primary;
    }

    public VirtualMachineNetworkInterfaceIpConfiguration withPrimary(Boolean primary) {
        this.primary = primary;
        return this;
    }

    public VirtualMachinePublicIpAddressConfiguration publicIpAddressConfiguration() {
        return this.publicIpAddressConfiguration;
    }

    public VirtualMachineNetworkInterfaceIpConfiguration withPublicIpAddressConfiguration(VirtualMachinePublicIpAddressConfiguration publicIpAddressConfiguration) {
        this.publicIpAddressConfiguration = publicIpAddressConfiguration;
        return this;
    }

    public IpVersions privateIpAddressVersion() {
        return this.privateIpAddressVersion;
    }

    public VirtualMachineNetworkInterfaceIpConfiguration withPrivateIpAddressVersion(IpVersions privateIpAddressVersion) {
        this.privateIpAddressVersion = privateIpAddressVersion;
        return this;
    }

    public List<SubResource> applicationSecurityGroups() {
        return this.applicationSecurityGroups;
    }

    public VirtualMachineNetworkInterfaceIpConfiguration withApplicationSecurityGroups(List<SubResource> applicationSecurityGroups) {
        this.applicationSecurityGroups = applicationSecurityGroups;
        return this;
    }

    public List<SubResource> applicationGatewayBackendAddressPools() {
        return this.applicationGatewayBackendAddressPools;
    }

    public VirtualMachineNetworkInterfaceIpConfiguration withApplicationGatewayBackendAddressPools(List<SubResource> applicationGatewayBackendAddressPools) {
        this.applicationGatewayBackendAddressPools = applicationGatewayBackendAddressPools;
        return this;
    }

    public List<SubResource> loadBalancerBackendAddressPools() {
        return this.loadBalancerBackendAddressPools;
    }

    public VirtualMachineNetworkInterfaceIpConfiguration withLoadBalancerBackendAddressPools(List<SubResource> loadBalancerBackendAddressPools) {
        this.loadBalancerBackendAddressPools = loadBalancerBackendAddressPools;
        return this;
    }

    public void validate() {
        if (this.name() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property name in model VirtualMachineNetworkInterfaceIpConfiguration"));
        }
        if (this.publicIpAddressConfiguration() != null) {
            this.publicIpAddressConfiguration().validate();
        }
    }
}

