/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.compute.models.CreationData;
import com.azure.resourcemanager.compute.models.DiskSecurityProfile;
import com.azure.resourcemanager.compute.models.DiskState;
import com.azure.resourcemanager.compute.models.Encryption;
import com.azure.resourcemanager.compute.models.EncryptionSettingsCollection;
import com.azure.resourcemanager.compute.models.HyperVGeneration;
import com.azure.resourcemanager.compute.models.NetworkAccessPolicy;
import com.azure.resourcemanager.compute.models.OperatingSystemTypes;
import com.azure.resourcemanager.compute.models.PropertyUpdatesInProgress;
import com.azure.resourcemanager.compute.models.PublicNetworkAccess;
import com.azure.resourcemanager.compute.models.PurchasePlanAutoGenerated;
import com.azure.resourcemanager.compute.models.ShareInfoElement;
import com.azure.resourcemanager.compute.models.SupportedCapabilities;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.List;

public final class DiskProperties {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(DiskProperties.class);
    @JsonProperty(value="timeCreated", access=JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime timeCreated;
    @JsonProperty(value="osType")
    private OperatingSystemTypes osType;
    @JsonProperty(value="hyperVGeneration")
    private HyperVGeneration hyperVGeneration;
    @JsonProperty(value="purchasePlan")
    private PurchasePlanAutoGenerated purchasePlan;
    @JsonProperty(value="supportedCapabilities")
    private SupportedCapabilities supportedCapabilities;
    @JsonProperty(value="creationData", required=true)
    private CreationData creationData;
    @JsonProperty(value="diskSizeGB")
    private Integer diskSizeGB;
    @JsonProperty(value="diskSizeBytes", access=JsonProperty.Access.WRITE_ONLY)
    private Long diskSizeBytes;
    @JsonProperty(value="uniqueId", access=JsonProperty.Access.WRITE_ONLY)
    private String uniqueId;
    @JsonProperty(value="encryptionSettingsCollection")
    private EncryptionSettingsCollection encryptionSettingsCollection;
    @JsonProperty(value="provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private String provisioningState;
    @JsonProperty(value="diskIOPSReadWrite")
    private Long diskIopsReadWrite;
    @JsonProperty(value="diskMBpsReadWrite")
    private Long diskMBpsReadWrite;
    @JsonProperty(value="diskIOPSReadOnly")
    private Long diskIopsReadOnly;
    @JsonProperty(value="diskMBpsReadOnly")
    private Long diskMBpsReadOnly;
    @JsonProperty(value="diskState", access=JsonProperty.Access.WRITE_ONLY)
    private DiskState diskState;
    @JsonProperty(value="encryption")
    private Encryption encryption;
    @JsonProperty(value="maxShares")
    private Integer maxShares;
    @JsonProperty(value="shareInfo", access=JsonProperty.Access.WRITE_ONLY)
    private List<ShareInfoElement> shareInfo;
    @JsonProperty(value="networkAccessPolicy")
    private NetworkAccessPolicy networkAccessPolicy;
    @JsonProperty(value="diskAccessId")
    private String diskAccessId;
    @JsonProperty(value="tier")
    private String tier;
    @JsonProperty(value="burstingEnabled")
    private Boolean burstingEnabled;
    @JsonProperty(value="propertyUpdatesInProgress", access=JsonProperty.Access.WRITE_ONLY)
    private PropertyUpdatesInProgress propertyUpdatesInProgress;
    @JsonProperty(value="supportsHibernation")
    private Boolean supportsHibernation;
    @JsonProperty(value="securityProfile")
    private DiskSecurityProfile securityProfile;
    @JsonProperty(value="completionPercent")
    private Float completionPercent;
    @JsonProperty(value="publicNetworkAccess")
    private PublicNetworkAccess publicNetworkAccess;

    public OffsetDateTime timeCreated() {
        return this.timeCreated;
    }

    public OperatingSystemTypes osType() {
        return this.osType;
    }

    public DiskProperties withOsType(OperatingSystemTypes osType) {
        this.osType = osType;
        return this;
    }

    public HyperVGeneration hyperVGeneration() {
        return this.hyperVGeneration;
    }

    public DiskProperties withHyperVGeneration(HyperVGeneration hyperVGeneration) {
        this.hyperVGeneration = hyperVGeneration;
        return this;
    }

    public PurchasePlanAutoGenerated purchasePlan() {
        return this.purchasePlan;
    }

    public DiskProperties withPurchasePlan(PurchasePlanAutoGenerated purchasePlan) {
        this.purchasePlan = purchasePlan;
        return this;
    }

    public SupportedCapabilities supportedCapabilities() {
        return this.supportedCapabilities;
    }

    public DiskProperties withSupportedCapabilities(SupportedCapabilities supportedCapabilities) {
        this.supportedCapabilities = supportedCapabilities;
        return this;
    }

    public CreationData creationData() {
        return this.creationData;
    }

    public DiskProperties withCreationData(CreationData creationData) {
        this.creationData = creationData;
        return this;
    }

    public Integer diskSizeGB() {
        return this.diskSizeGB;
    }

    public DiskProperties withDiskSizeGB(Integer diskSizeGB) {
        this.diskSizeGB = diskSizeGB;
        return this;
    }

    public Long diskSizeBytes() {
        return this.diskSizeBytes;
    }

    public String uniqueId() {
        return this.uniqueId;
    }

    public EncryptionSettingsCollection encryptionSettingsCollection() {
        return this.encryptionSettingsCollection;
    }

    public DiskProperties withEncryptionSettingsCollection(EncryptionSettingsCollection encryptionSettingsCollection) {
        this.encryptionSettingsCollection = encryptionSettingsCollection;
        return this;
    }

    public String provisioningState() {
        return this.provisioningState;
    }

    public Long diskIopsReadWrite() {
        return this.diskIopsReadWrite;
    }

    public DiskProperties withDiskIopsReadWrite(Long diskIopsReadWrite) {
        this.diskIopsReadWrite = diskIopsReadWrite;
        return this;
    }

    public Long diskMBpsReadWrite() {
        return this.diskMBpsReadWrite;
    }

    public DiskProperties withDiskMBpsReadWrite(Long diskMBpsReadWrite) {
        this.diskMBpsReadWrite = diskMBpsReadWrite;
        return this;
    }

    public Long diskIopsReadOnly() {
        return this.diskIopsReadOnly;
    }

    public DiskProperties withDiskIopsReadOnly(Long diskIopsReadOnly) {
        this.diskIopsReadOnly = diskIopsReadOnly;
        return this;
    }

    public Long diskMBpsReadOnly() {
        return this.diskMBpsReadOnly;
    }

    public DiskProperties withDiskMBpsReadOnly(Long diskMBpsReadOnly) {
        this.diskMBpsReadOnly = diskMBpsReadOnly;
        return this;
    }

    public DiskState diskState() {
        return this.diskState;
    }

    public Encryption encryption() {
        return this.encryption;
    }

    public DiskProperties withEncryption(Encryption encryption) {
        this.encryption = encryption;
        return this;
    }

    public Integer maxShares() {
        return this.maxShares;
    }

    public DiskProperties withMaxShares(Integer maxShares) {
        this.maxShares = maxShares;
        return this;
    }

    public List<ShareInfoElement> shareInfo() {
        return this.shareInfo;
    }

    public NetworkAccessPolicy networkAccessPolicy() {
        return this.networkAccessPolicy;
    }

    public DiskProperties withNetworkAccessPolicy(NetworkAccessPolicy networkAccessPolicy) {
        this.networkAccessPolicy = networkAccessPolicy;
        return this;
    }

    public String diskAccessId() {
        return this.diskAccessId;
    }

    public DiskProperties withDiskAccessId(String diskAccessId) {
        this.diskAccessId = diskAccessId;
        return this;
    }

    public String tier() {
        return this.tier;
    }

    public DiskProperties withTier(String tier) {
        this.tier = tier;
        return this;
    }

    public Boolean burstingEnabled() {
        return this.burstingEnabled;
    }

    public DiskProperties withBurstingEnabled(Boolean burstingEnabled) {
        this.burstingEnabled = burstingEnabled;
        return this;
    }

    public PropertyUpdatesInProgress propertyUpdatesInProgress() {
        return this.propertyUpdatesInProgress;
    }

    public Boolean supportsHibernation() {
        return this.supportsHibernation;
    }

    public DiskProperties withSupportsHibernation(Boolean supportsHibernation) {
        this.supportsHibernation = supportsHibernation;
        return this;
    }

    public DiskSecurityProfile securityProfile() {
        return this.securityProfile;
    }

    public DiskProperties withSecurityProfile(DiskSecurityProfile securityProfile) {
        this.securityProfile = securityProfile;
        return this;
    }

    public Float completionPercent() {
        return this.completionPercent;
    }

    public DiskProperties withCompletionPercent(Float completionPercent) {
        this.completionPercent = completionPercent;
        return this;
    }

    public PublicNetworkAccess publicNetworkAccess() {
        return this.publicNetworkAccess;
    }

    public DiskProperties withPublicNetworkAccess(PublicNetworkAccess publicNetworkAccess) {
        this.publicNetworkAccess = publicNetworkAccess;
        return this;
    }

    public void validate() {
        if (this.purchasePlan() != null) {
            this.purchasePlan().validate();
        }
        if (this.supportedCapabilities() != null) {
            this.supportedCapabilities().validate();
        }
        if (this.creationData() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property creationData in model DiskProperties"));
        }
        this.creationData().validate();
        if (this.encryptionSettingsCollection() != null) {
            this.encryptionSettingsCollection().validate();
        }
        if (this.encryption() != null) {
            this.encryption().validate();
        }
        if (this.shareInfo() != null) {
            this.shareInfo().forEach(e -> e.validate());
        }
        if (this.propertyUpdatesInProgress() != null) {
            this.propertyUpdatesInProgress().validate();
        }
        if (this.securityProfile() != null) {
            this.securityProfile().validate();
        }
    }
}

