/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.compute.models.ApiEntityReference;
import com.azure.resourcemanager.compute.models.ConsistencyModeTypes;
import com.azure.resourcemanager.compute.models.RestorePointProvisioningDetails;
import com.azure.resourcemanager.compute.models.RestorePointSourceMetadata;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class RestorePointProperties {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(RestorePointProperties.class);
    @JsonProperty(value="excludeDisks")
    private List<ApiEntityReference> excludeDisks;
    @JsonProperty(value="sourceMetadata", access=JsonProperty.Access.WRITE_ONLY)
    private RestorePointSourceMetadata sourceMetadata;
    @JsonProperty(value="provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private String provisioningState;
    @JsonProperty(value="consistencyMode", access=JsonProperty.Access.WRITE_ONLY)
    private ConsistencyModeTypes consistencyMode;
    @JsonProperty(value="provisioningDetails", access=JsonProperty.Access.WRITE_ONLY)
    private RestorePointProvisioningDetails provisioningDetails;

    public List<ApiEntityReference> excludeDisks() {
        return this.excludeDisks;
    }

    public RestorePointProperties withExcludeDisks(List<ApiEntityReference> excludeDisks) {
        this.excludeDisks = excludeDisks;
        return this;
    }

    public RestorePointSourceMetadata sourceMetadata() {
        return this.sourceMetadata;
    }

    public String provisioningState() {
        return this.provisioningState;
    }

    public ConsistencyModeTypes consistencyMode() {
        return this.consistencyMode;
    }

    public RestorePointProvisioningDetails provisioningDetails() {
        return this.provisioningDetails;
    }

    public void validate() {
        if (this.excludeDisks() != null) {
            this.excludeDisks().forEach(e -> e.validate());
        }
        if (this.sourceMetadata() != null) {
            this.sourceMetadata().validate();
        }
        if (this.provisioningDetails() != null) {
            this.provisioningDetails().validate();
        }
    }
}

