/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.fluent.models;

import com.azure.core.management.SubResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.compute.fluent.models.VirtualMachineInstanceViewInner;
import com.azure.resourcemanager.compute.models.AdditionalCapabilities;
import com.azure.resourcemanager.compute.models.ApplicationProfile;
import com.azure.resourcemanager.compute.models.BillingProfile;
import com.azure.resourcemanager.compute.models.CapacityReservationProfile;
import com.azure.resourcemanager.compute.models.DiagnosticsProfile;
import com.azure.resourcemanager.compute.models.HardwareProfile;
import com.azure.resourcemanager.compute.models.NetworkProfile;
import com.azure.resourcemanager.compute.models.OSProfile;
import com.azure.resourcemanager.compute.models.ScheduledEventsProfile;
import com.azure.resourcemanager.compute.models.SecurityProfile;
import com.azure.resourcemanager.compute.models.StorageProfile;
import com.azure.resourcemanager.compute.models.VirtualMachineEvictionPolicyTypes;
import com.azure.resourcemanager.compute.models.VirtualMachinePriorityTypes;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

public final class VirtualMachinePropertiesInner {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(VirtualMachinePropertiesInner.class);
    @JsonProperty(value="hardwareProfile")
    private HardwareProfile hardwareProfile;
    @JsonProperty(value="storageProfile")
    private StorageProfile storageProfile;
    @JsonProperty(value="additionalCapabilities")
    private AdditionalCapabilities additionalCapabilities;
    @JsonProperty(value="osProfile")
    private OSProfile osProfile;
    @JsonProperty(value="networkProfile")
    private NetworkProfile networkProfile;
    @JsonProperty(value="securityProfile")
    private SecurityProfile securityProfile;
    @JsonProperty(value="diagnosticsProfile")
    private DiagnosticsProfile diagnosticsProfile;
    @JsonProperty(value="availabilitySet")
    private SubResource availabilitySet;
    @JsonProperty(value="virtualMachineScaleSet")
    private SubResource virtualMachineScaleSet;
    @JsonProperty(value="proximityPlacementGroup")
    private SubResource proximityPlacementGroup;
    @JsonProperty(value="priority")
    private VirtualMachinePriorityTypes priority;
    @JsonProperty(value="evictionPolicy")
    private VirtualMachineEvictionPolicyTypes evictionPolicy;
    @JsonProperty(value="billingProfile")
    private BillingProfile billingProfile;
    @JsonProperty(value="host")
    private SubResource host;
    @JsonProperty(value="hostGroup")
    private SubResource hostGroup;
    @JsonProperty(value="provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private String provisioningState;
    @JsonProperty(value="instanceView", access=JsonProperty.Access.WRITE_ONLY)
    private VirtualMachineInstanceViewInner instanceView;
    @JsonProperty(value="licenseType")
    private String licenseType;
    @JsonProperty(value="vmId", access=JsonProperty.Access.WRITE_ONLY)
    private String vmId;
    @JsonProperty(value="extensionsTimeBudget")
    private String extensionsTimeBudget;
    @JsonProperty(value="platformFaultDomain")
    private Integer platformFaultDomain;
    @JsonProperty(value="scheduledEventsProfile")
    private ScheduledEventsProfile scheduledEventsProfile;
    @JsonProperty(value="userData")
    private String userData;
    @JsonProperty(value="capacityReservation")
    private CapacityReservationProfile capacityReservation;
    @JsonProperty(value="applicationProfile")
    private ApplicationProfile applicationProfile;

    public HardwareProfile hardwareProfile() {
        return this.hardwareProfile;
    }

    public VirtualMachinePropertiesInner withHardwareProfile(HardwareProfile hardwareProfile) {
        this.hardwareProfile = hardwareProfile;
        return this;
    }

    public StorageProfile storageProfile() {
        return this.storageProfile;
    }

    public VirtualMachinePropertiesInner withStorageProfile(StorageProfile storageProfile) {
        this.storageProfile = storageProfile;
        return this;
    }

    public AdditionalCapabilities additionalCapabilities() {
        return this.additionalCapabilities;
    }

    public VirtualMachinePropertiesInner withAdditionalCapabilities(AdditionalCapabilities additionalCapabilities) {
        this.additionalCapabilities = additionalCapabilities;
        return this;
    }

    public OSProfile osProfile() {
        return this.osProfile;
    }

    public VirtualMachinePropertiesInner withOsProfile(OSProfile osProfile) {
        this.osProfile = osProfile;
        return this;
    }

    public NetworkProfile networkProfile() {
        return this.networkProfile;
    }

    public VirtualMachinePropertiesInner withNetworkProfile(NetworkProfile networkProfile) {
        this.networkProfile = networkProfile;
        return this;
    }

    public SecurityProfile securityProfile() {
        return this.securityProfile;
    }

    public VirtualMachinePropertiesInner withSecurityProfile(SecurityProfile securityProfile) {
        this.securityProfile = securityProfile;
        return this;
    }

    public DiagnosticsProfile diagnosticsProfile() {
        return this.diagnosticsProfile;
    }

    public VirtualMachinePropertiesInner withDiagnosticsProfile(DiagnosticsProfile diagnosticsProfile) {
        this.diagnosticsProfile = diagnosticsProfile;
        return this;
    }

    public SubResource availabilitySet() {
        return this.availabilitySet;
    }

    public VirtualMachinePropertiesInner withAvailabilitySet(SubResource availabilitySet) {
        this.availabilitySet = availabilitySet;
        return this;
    }

    public SubResource virtualMachineScaleSet() {
        return this.virtualMachineScaleSet;
    }

    public VirtualMachinePropertiesInner withVirtualMachineScaleSet(SubResource virtualMachineScaleSet) {
        this.virtualMachineScaleSet = virtualMachineScaleSet;
        return this;
    }

    public SubResource proximityPlacementGroup() {
        return this.proximityPlacementGroup;
    }

    public VirtualMachinePropertiesInner withProximityPlacementGroup(SubResource proximityPlacementGroup) {
        this.proximityPlacementGroup = proximityPlacementGroup;
        return this;
    }

    public VirtualMachinePriorityTypes priority() {
        return this.priority;
    }

    public VirtualMachinePropertiesInner withPriority(VirtualMachinePriorityTypes priority) {
        this.priority = priority;
        return this;
    }

    public VirtualMachineEvictionPolicyTypes evictionPolicy() {
        return this.evictionPolicy;
    }

    public VirtualMachinePropertiesInner withEvictionPolicy(VirtualMachineEvictionPolicyTypes evictionPolicy) {
        this.evictionPolicy = evictionPolicy;
        return this;
    }

    public BillingProfile billingProfile() {
        return this.billingProfile;
    }

    public VirtualMachinePropertiesInner withBillingProfile(BillingProfile billingProfile) {
        this.billingProfile = billingProfile;
        return this;
    }

    public SubResource host() {
        return this.host;
    }

    public VirtualMachinePropertiesInner withHost(SubResource host) {
        this.host = host;
        return this;
    }

    public SubResource hostGroup() {
        return this.hostGroup;
    }

    public VirtualMachinePropertiesInner withHostGroup(SubResource hostGroup) {
        this.hostGroup = hostGroup;
        return this;
    }

    public String provisioningState() {
        return this.provisioningState;
    }

    public VirtualMachineInstanceViewInner instanceView() {
        return this.instanceView;
    }

    public String licenseType() {
        return this.licenseType;
    }

    public VirtualMachinePropertiesInner withLicenseType(String licenseType) {
        this.licenseType = licenseType;
        return this;
    }

    public String vmId() {
        return this.vmId;
    }

    public String extensionsTimeBudget() {
        return this.extensionsTimeBudget;
    }

    public VirtualMachinePropertiesInner withExtensionsTimeBudget(String extensionsTimeBudget) {
        this.extensionsTimeBudget = extensionsTimeBudget;
        return this;
    }

    public Integer platformFaultDomain() {
        return this.platformFaultDomain;
    }

    public VirtualMachinePropertiesInner withPlatformFaultDomain(Integer platformFaultDomain) {
        this.platformFaultDomain = platformFaultDomain;
        return this;
    }

    public ScheduledEventsProfile scheduledEventsProfile() {
        return this.scheduledEventsProfile;
    }

    public VirtualMachinePropertiesInner withScheduledEventsProfile(ScheduledEventsProfile scheduledEventsProfile) {
        this.scheduledEventsProfile = scheduledEventsProfile;
        return this;
    }

    public String userData() {
        return this.userData;
    }

    public VirtualMachinePropertiesInner withUserData(String userData) {
        this.userData = userData;
        return this;
    }

    public CapacityReservationProfile capacityReservation() {
        return this.capacityReservation;
    }

    public VirtualMachinePropertiesInner withCapacityReservation(CapacityReservationProfile capacityReservation) {
        this.capacityReservation = capacityReservation;
        return this;
    }

    public ApplicationProfile applicationProfile() {
        return this.applicationProfile;
    }

    public VirtualMachinePropertiesInner withApplicationProfile(ApplicationProfile applicationProfile) {
        this.applicationProfile = applicationProfile;
        return this;
    }

    public void validate() {
        if (this.hardwareProfile() != null) {
            this.hardwareProfile().validate();
        }
        if (this.storageProfile() != null) {
            this.storageProfile().validate();
        }
        if (this.additionalCapabilities() != null) {
            this.additionalCapabilities().validate();
        }
        if (this.osProfile() != null) {
            this.osProfile().validate();
        }
        if (this.networkProfile() != null) {
            this.networkProfile().validate();
        }
        if (this.securityProfile() != null) {
            this.securityProfile().validate();
        }
        if (this.diagnosticsProfile() != null) {
            this.diagnosticsProfile().validate();
        }
        if (this.billingProfile() != null) {
            this.billingProfile().validate();
        }
        if (this.instanceView() != null) {
            this.instanceView().validate();
        }
        if (this.scheduledEventsProfile() != null) {
            this.scheduledEventsProfile().validate();
        }
        if (this.capacityReservation() != null) {
            this.capacityReservation().validate();
        }
        if (this.applicationProfile() != null) {
            this.applicationProfile().validate();
        }
    }
}

