/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.compute.fluent.GallerySharingProfilesClient;
import com.azure.resourcemanager.compute.fluent.models.SharingUpdateInner;
import com.azure.resourcemanager.compute.implementation.ComputeManagementClientImpl;
import com.azure.resourcemanager.compute.models.ApiErrorException;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class GallerySharingProfilesClientImpl
implements GallerySharingProfilesClient {
    private final ClientLogger logger = new ClientLogger(GallerySharingProfilesClientImpl.class);
    private final GallerySharingProfilesService service;
    private final ComputeManagementClientImpl client;

    GallerySharingProfilesClientImpl(ComputeManagementClientImpl client) {
        this.service = (GallerySharingProfilesService)RestProxy.create(GallerySharingProfilesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String galleryName, SharingUpdateInner sharingUpdate) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (galleryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter galleryName is required and cannot be null."));
        }
        if (sharingUpdate == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter sharingUpdate is required and cannot be null."));
        }
        sharingUpdate.validate();
        String apiVersion = "2021-07-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.update(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, galleryName, "2021-07-01", sharingUpdate, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String galleryName, SharingUpdateInner sharingUpdate, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (galleryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter galleryName is required and cannot be null."));
        }
        if (sharingUpdate == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter sharingUpdate is required and cannot be null."));
        }
        sharingUpdate.validate();
        String apiVersion = "2021-07-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.update(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, galleryName, "2021-07-01", sharingUpdate, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public PollerFlux<PollResult<SharingUpdateInner>, SharingUpdateInner> beginUpdateAsync(String resourceGroupName, String galleryName, SharingUpdateInner sharingUpdate) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, galleryName, sharingUpdate);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)SharingUpdateInner.class), (Type)((Object)SharingUpdateInner.class), Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PollerFlux<PollResult<SharingUpdateInner>, SharingUpdateInner> beginUpdateAsync(String resourceGroupName, String galleryName, SharingUpdateInner sharingUpdate, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, galleryName, sharingUpdate, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)SharingUpdateInner.class), (Type)((Object)SharingUpdateInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SyncPoller<PollResult<SharingUpdateInner>, SharingUpdateInner> beginUpdate(String resourceGroupName, String galleryName, SharingUpdateInner sharingUpdate) {
        return this.beginUpdateAsync(resourceGroupName, galleryName, sharingUpdate).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SyncPoller<PollResult<SharingUpdateInner>, SharingUpdateInner> beginUpdate(String resourceGroupName, String galleryName, SharingUpdateInner sharingUpdate, Context context) {
        return this.beginUpdateAsync(resourceGroupName, galleryName, sharingUpdate, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SharingUpdateInner> updateAsync(String resourceGroupName, String galleryName, SharingUpdateInner sharingUpdate) {
        return this.beginUpdateAsync(resourceGroupName, galleryName, sharingUpdate).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<SharingUpdateInner> updateAsync(String resourceGroupName, String galleryName, SharingUpdateInner sharingUpdate, Context context) {
        return this.beginUpdateAsync(resourceGroupName, galleryName, sharingUpdate, context).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SharingUpdateInner update(String resourceGroupName, String galleryName, SharingUpdateInner sharingUpdate) {
        return (SharingUpdateInner)this.updateAsync(resourceGroupName, galleryName, sharingUpdate).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public SharingUpdateInner update(String resourceGroupName, String galleryName, SharingUpdateInner sharingUpdate, Context context) {
        return (SharingUpdateInner)this.updateAsync(resourceGroupName, galleryName, sharingUpdate, context).block();
    }

    @Host(value="{$host}")
    @ServiceInterface(name="ComputeManagementCli")
    private static interface GallerySharingProfilesService {
        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/share")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ApiErrorException.class)
        public Mono<Response<Flux<ByteBuffer>>> update(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="galleryName") String var4, @QueryParam(value="api-version") String var5, @BodyParam(value="application/json") SharingUpdateInner var6, @HeaderParam(value="Accept") String var7, Context var8);
    }
}

