// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.resourcemanager.compute.fluent.models.CommunityGalleryImageInner;
import reactor.core.publisher.Mono;

/** An instance of this class provides access to all the operations defined in CommunityGalleryImagesClient. */
public interface CommunityGalleryImagesClient {
    /**
     * Get a community gallery image.
     *
     * @param location Resource location.
     * @param publicGalleryName The public name of the community gallery.
     * @param galleryImageName The name of the community gallery image definition.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a community gallery image.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<CommunityGalleryImageInner>> getWithResponseAsync(
        String location, String publicGalleryName, String galleryImageName);

    /**
     * Get a community gallery image.
     *
     * @param location Resource location.
     * @param publicGalleryName The public name of the community gallery.
     * @param galleryImageName The name of the community gallery image definition.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a community gallery image.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<CommunityGalleryImageInner> getAsync(String location, String publicGalleryName, String galleryImageName);

    /**
     * Get a community gallery image.
     *
     * @param location Resource location.
     * @param publicGalleryName The public name of the community gallery.
     * @param galleryImageName The name of the community gallery image definition.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a community gallery image.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    CommunityGalleryImageInner get(String location, String publicGalleryName, String galleryImageName);

    /**
     * Get a community gallery image.
     *
     * @param location Resource location.
     * @param publicGalleryName The public name of the community gallery.
     * @param galleryImageName The name of the community gallery image definition.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.compute.models.ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a community gallery image.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<CommunityGalleryImageInner> getWithResponse(
        String location, String publicGalleryName, String galleryImageName, Context context);
}
