// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.resourcemanager.compute.fluent.models.ProximityPlacementGroupInner;
import com.azure.resourcemanager.compute.models.ProximityPlacementGroupUpdate;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsDelete;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsGet;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsListing;
import reactor.core.publisher.Mono;

/** An instance of this class provides access to all the operations defined in ProximityPlacementGroupsClient. */
public interface ProximityPlacementGroupsClient
    extends InnerSupportsGet<ProximityPlacementGroupInner>,
        InnerSupportsListing<ProximityPlacementGroupInner>,
        InnerSupportsDelete<Void> {
    /**
     * Create or update a proximity placement group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param proximityPlacementGroupName The name of the proximity placement group.
     * @param parameters Parameters supplied to the Create Proximity Placement Group operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the proximity placement group.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<ProximityPlacementGroupInner>> createOrUpdateWithResponseAsync(
        String resourceGroupName, String proximityPlacementGroupName, ProximityPlacementGroupInner parameters);

    /**
     * Create or update a proximity placement group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param proximityPlacementGroupName The name of the proximity placement group.
     * @param parameters Parameters supplied to the Create Proximity Placement Group operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the proximity placement group.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<ProximityPlacementGroupInner> createOrUpdateAsync(
        String resourceGroupName, String proximityPlacementGroupName, ProximityPlacementGroupInner parameters);

    /**
     * Create or update a proximity placement group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param proximityPlacementGroupName The name of the proximity placement group.
     * @param parameters Parameters supplied to the Create Proximity Placement Group operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the proximity placement group.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ProximityPlacementGroupInner createOrUpdate(
        String resourceGroupName, String proximityPlacementGroupName, ProximityPlacementGroupInner parameters);

    /**
     * Create or update a proximity placement group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param proximityPlacementGroupName The name of the proximity placement group.
     * @param parameters Parameters supplied to the Create Proximity Placement Group operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the proximity placement group.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<ProximityPlacementGroupInner> createOrUpdateWithResponse(
        String resourceGroupName,
        String proximityPlacementGroupName,
        ProximityPlacementGroupInner parameters,
        Context context);

    /**
     * Update a proximity placement group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param proximityPlacementGroupName The name of the proximity placement group.
     * @param parameters Parameters supplied to the Update Proximity Placement Group operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the proximity placement group.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<ProximityPlacementGroupInner>> updateWithResponseAsync(
        String resourceGroupName, String proximityPlacementGroupName, ProximityPlacementGroupUpdate parameters);

    /**
     * Update a proximity placement group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param proximityPlacementGroupName The name of the proximity placement group.
     * @param parameters Parameters supplied to the Update Proximity Placement Group operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the proximity placement group.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<ProximityPlacementGroupInner> updateAsync(
        String resourceGroupName, String proximityPlacementGroupName, ProximityPlacementGroupUpdate parameters);

    /**
     * Update a proximity placement group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param proximityPlacementGroupName The name of the proximity placement group.
     * @param parameters Parameters supplied to the Update Proximity Placement Group operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the proximity placement group.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ProximityPlacementGroupInner update(
        String resourceGroupName, String proximityPlacementGroupName, ProximityPlacementGroupUpdate parameters);

    /**
     * Update a proximity placement group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param proximityPlacementGroupName The name of the proximity placement group.
     * @param parameters Parameters supplied to the Update Proximity Placement Group operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the proximity placement group.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<ProximityPlacementGroupInner> updateWithResponse(
        String resourceGroupName,
        String proximityPlacementGroupName,
        ProximityPlacementGroupUpdate parameters,
        Context context);

    /**
     * Delete a proximity placement group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param proximityPlacementGroupName The name of the proximity placement group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String proximityPlacementGroupName);

    /**
     * Delete a proximity placement group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param proximityPlacementGroupName The name of the proximity placement group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteAsync(String resourceGroupName, String proximityPlacementGroupName);

    /**
     * Delete a proximity placement group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param proximityPlacementGroupName The name of the proximity placement group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void delete(String resourceGroupName, String proximityPlacementGroupName);

    /**
     * Delete a proximity placement group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param proximityPlacementGroupName The name of the proximity placement group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Void> deleteWithResponse(String resourceGroupName, String proximityPlacementGroupName, Context context);

    /**
     * Retrieves information about a proximity placement group .
     *
     * @param resourceGroupName The name of the resource group.
     * @param proximityPlacementGroupName The name of the proximity placement group.
     * @param includeColocationStatus includeColocationStatus=true enables fetching the colocation status of all the
     *     resources in the proximity placement group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the proximity placement group.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<ProximityPlacementGroupInner>> getByResourceGroupWithResponseAsync(
        String resourceGroupName, String proximityPlacementGroupName, String includeColocationStatus);

    /**
     * Retrieves information about a proximity placement group .
     *
     * @param resourceGroupName The name of the resource group.
     * @param proximityPlacementGroupName The name of the proximity placement group.
     * @param includeColocationStatus includeColocationStatus=true enables fetching the colocation status of all the
     *     resources in the proximity placement group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the proximity placement group.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<ProximityPlacementGroupInner> getByResourceGroupAsync(
        String resourceGroupName, String proximityPlacementGroupName, String includeColocationStatus);

    /**
     * Retrieves information about a proximity placement group .
     *
     * @param resourceGroupName The name of the resource group.
     * @param proximityPlacementGroupName The name of the proximity placement group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the proximity placement group.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<ProximityPlacementGroupInner> getByResourceGroupAsync(
        String resourceGroupName, String proximityPlacementGroupName);

    /**
     * Retrieves information about a proximity placement group .
     *
     * @param resourceGroupName The name of the resource group.
     * @param proximityPlacementGroupName The name of the proximity placement group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the proximity placement group.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ProximityPlacementGroupInner getByResourceGroup(String resourceGroupName, String proximityPlacementGroupName);

    /**
     * Retrieves information about a proximity placement group .
     *
     * @param resourceGroupName The name of the resource group.
     * @param proximityPlacementGroupName The name of the proximity placement group.
     * @param includeColocationStatus includeColocationStatus=true enables fetching the colocation status of all the
     *     resources in the proximity placement group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the proximity placement group.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<ProximityPlacementGroupInner> getByResourceGroupWithResponse(
        String resourceGroupName, String proximityPlacementGroupName, String includeColocationStatus, Context context);

    /**
     * Lists all proximity placement groups in a subscription.
     *
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List Proximity Placement Group operation response.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<ProximityPlacementGroupInner> listAsync();

    /**
     * Lists all proximity placement groups in a subscription.
     *
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List Proximity Placement Group operation response.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<ProximityPlacementGroupInner> list();

    /**
     * Lists all proximity placement groups in a subscription.
     *
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List Proximity Placement Group operation response.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<ProximityPlacementGroupInner> list(Context context);

    /**
     * Lists all proximity placement groups in a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List Proximity Placement Group operation response.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<ProximityPlacementGroupInner> listByResourceGroupAsync(String resourceGroupName);

    /**
     * Lists all proximity placement groups in a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List Proximity Placement Group operation response.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<ProximityPlacementGroupInner> listByResourceGroup(String resourceGroupName);

    /**
     * Lists all proximity placement groups in a resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List Proximity Placement Group operation response.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<ProximityPlacementGroupInner> listByResourceGroup(String resourceGroupName, Context context);
}
