// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.implementation;

import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.http.rest.StreamResponse;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.resourcemanager.compute.fluent.CloudServiceRoleInstancesClient;
import com.azure.resourcemanager.compute.fluent.models.RoleInstanceInner;
import com.azure.resourcemanager.compute.fluent.models.RoleInstanceViewInner;
import com.azure.resourcemanager.compute.models.ApiErrorException;
import com.azure.resourcemanager.compute.models.InstanceViewTypes;
import com.azure.resourcemanager.compute.models.RoleInstanceListResult;
import com.fasterxml.jackson.databind.util.ByteBufferBackedInputStream;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.nio.ByteBuffer;
import java.util.Enumeration;
import java.util.Iterator;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/** An instance of this class provides access to all the operations defined in CloudServiceRoleInstancesClient. */
public final class CloudServiceRoleInstancesClientImpl implements CloudServiceRoleInstancesClient {
    private final ClientLogger logger = new ClientLogger(CloudServiceRoleInstancesClientImpl.class);

    /** The proxy service used to perform REST calls. */
    private final CloudServiceRoleInstancesService service;

    /** The service client containing this operation class. */
    private final ComputeManagementClientImpl client;

    /**
     * Initializes an instance of CloudServiceRoleInstancesClientImpl.
     *
     * @param client the instance of the service client containing this operation class.
     */
    CloudServiceRoleInstancesClientImpl(ComputeManagementClientImpl client) {
        this.service =
            RestProxy
                .create(
                    CloudServiceRoleInstancesService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for ComputeManagementClientCloudServiceRoleInstances to be used by the
     * proxy service to perform REST calls.
     */
    @Host("{$host}")
    @ServiceInterface(name = "ComputeManagementCli")
    private interface CloudServiceRoleInstancesService {
        @Headers({"Content-Type: application/json"})
        @Delete(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute"
                + "/cloudServices/{cloudServiceName}/roleInstances/{roleInstanceName}")
        @ExpectedResponses({200, 202, 204})
        @UnexpectedResponseExceptionType(ApiErrorException.class)
        Mono<Response<Flux<ByteBuffer>>> delete(
            @HostParam("$host") String endpoint,
            @PathParam("roleInstanceName") String roleInstanceName,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("cloudServiceName") String cloudServiceName,
            @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute"
                + "/cloudServices/{cloudServiceName}/roleInstances/{roleInstanceName}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ApiErrorException.class)
        Mono<Response<RoleInstanceInner>> get(
            @HostParam("$host") String endpoint,
            @PathParam("roleInstanceName") String roleInstanceName,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("cloudServiceName") String cloudServiceName,
            @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion,
            @QueryParam("$expand") InstanceViewTypes expand,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute"
                + "/cloudServices/{cloudServiceName}/roleInstances/{roleInstanceName}/instanceView")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ApiErrorException.class)
        Mono<Response<RoleInstanceViewInner>> getInstanceView(
            @HostParam("$host") String endpoint,
            @PathParam("roleInstanceName") String roleInstanceName,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("cloudServiceName") String cloudServiceName,
            @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute"
                + "/cloudServices/{cloudServiceName}/roleInstances")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ApiErrorException.class)
        Mono<Response<RoleInstanceListResult>> list(
            @HostParam("$host") String endpoint,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("cloudServiceName") String cloudServiceName,
            @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion,
            @QueryParam("$expand") InstanceViewTypes expand,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Post(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute"
                + "/cloudServices/{cloudServiceName}/roleInstances/{roleInstanceName}/restart")
        @ExpectedResponses({200, 202})
        @UnexpectedResponseExceptionType(ApiErrorException.class)
        Mono<Response<Flux<ByteBuffer>>> restart(
            @HostParam("$host") String endpoint,
            @PathParam("roleInstanceName") String roleInstanceName,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("cloudServiceName") String cloudServiceName,
            @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Post(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute"
                + "/cloudServices/{cloudServiceName}/roleInstances/{roleInstanceName}/reimage")
        @ExpectedResponses({200, 202})
        @UnexpectedResponseExceptionType(ApiErrorException.class)
        Mono<Response<Flux<ByteBuffer>>> reimage(
            @HostParam("$host") String endpoint,
            @PathParam("roleInstanceName") String roleInstanceName,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("cloudServiceName") String cloudServiceName,
            @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Post(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute"
                + "/cloudServices/{cloudServiceName}/roleInstances/{roleInstanceName}/rebuild")
        @ExpectedResponses({200, 202})
        @UnexpectedResponseExceptionType(ApiErrorException.class)
        Mono<Response<Flux<ByteBuffer>>> rebuild(
            @HostParam("$host") String endpoint,
            @PathParam("roleInstanceName") String roleInstanceName,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("cloudServiceName") String cloudServiceName,
            @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute"
                + "/cloudServices/{cloudServiceName}/roleInstances/{roleInstanceName}/remoteDesktopFile")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<StreamResponse> getRemoteDesktopFile(
            @HostParam("$host") String endpoint,
            @PathParam("roleInstanceName") String roleInstanceName,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("cloudServiceName") String cloudServiceName,
            @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Get("{nextLink}")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ApiErrorException.class)
        Mono<Response<RoleInstanceListResult>> listNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink,
            @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept,
            Context context);
    }

    /**
     * Deletes a role instance from a cloud service.
     *
     * @param roleInstanceName Name of the role instance.
     * @param resourceGroupName The resourceGroupName parameter.
     * @param cloudServiceName The cloudServiceName parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(
        String roleInstanceName, String resourceGroupName, String cloudServiceName) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (roleInstanceName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter roleInstanceName is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (cloudServiceName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter cloudServiceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String apiVersion = "2021-03-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .delete(
                            this.client.getEndpoint(),
                            roleInstanceName,
                            resourceGroupName,
                            cloudServiceName,
                            this.client.getSubscriptionId(),
                            apiVersion,
                            accept,
                            context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Deletes a role instance from a cloud service.
     *
     * @param roleInstanceName Name of the role instance.
     * @param resourceGroupName The resourceGroupName parameter.
     * @param cloudServiceName The cloudServiceName parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(
        String roleInstanceName, String resourceGroupName, String cloudServiceName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (roleInstanceName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter roleInstanceName is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (cloudServiceName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter cloudServiceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String apiVersion = "2021-03-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .delete(
                this.client.getEndpoint(),
                roleInstanceName,
                resourceGroupName,
                cloudServiceName,
                this.client.getSubscriptionId(),
                apiVersion,
                accept,
                context);
    }

    /**
     * Deletes a role instance from a cloud service.
     *
     * @param roleInstanceName Name of the role instance.
     * @param resourceGroupName The resourceGroupName parameter.
     * @param cloudServiceName The cloudServiceName parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginDeleteAsync(
        String roleInstanceName, String resourceGroupName, String cloudServiceName) {
        Mono<Response<Flux<ByteBuffer>>> mono =
            deleteWithResponseAsync(roleInstanceName, resourceGroupName, cloudServiceName);
        return this
            .client
            .<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class, Context.NONE);
    }

    /**
     * Deletes a role instance from a cloud service.
     *
     * @param roleInstanceName Name of the role instance.
     * @param resourceGroupName The resourceGroupName parameter.
     * @param cloudServiceName The cloudServiceName parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(
        String roleInstanceName, String resourceGroupName, String cloudServiceName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono =
            deleteWithResponseAsync(roleInstanceName, resourceGroupName, cloudServiceName, context);
        return this
            .client
            .<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class, context);
    }

    /**
     * Deletes a role instance from a cloud service.
     *
     * @param roleInstanceName Name of the role instance.
     * @param resourceGroupName The resourceGroupName parameter.
     * @param cloudServiceName The cloudServiceName parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(
        String roleInstanceName, String resourceGroupName, String cloudServiceName) {
        return beginDeleteAsync(roleInstanceName, resourceGroupName, cloudServiceName).getSyncPoller();
    }

    /**
     * Deletes a role instance from a cloud service.
     *
     * @param roleInstanceName Name of the role instance.
     * @param resourceGroupName The resourceGroupName parameter.
     * @param cloudServiceName The cloudServiceName parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(
        String roleInstanceName, String resourceGroupName, String cloudServiceName, Context context) {
        return beginDeleteAsync(roleInstanceName, resourceGroupName, cloudServiceName, context).getSyncPoller();
    }

    /**
     * Deletes a role instance from a cloud service.
     *
     * @param roleInstanceName Name of the role instance.
     * @param resourceGroupName The resourceGroupName parameter.
     * @param cloudServiceName The cloudServiceName parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String roleInstanceName, String resourceGroupName, String cloudServiceName) {
        return beginDeleteAsync(roleInstanceName, resourceGroupName, cloudServiceName)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Deletes a role instance from a cloud service.
     *
     * @param roleInstanceName Name of the role instance.
     * @param resourceGroupName The resourceGroupName parameter.
     * @param cloudServiceName The cloudServiceName parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Void> deleteAsync(
        String roleInstanceName, String resourceGroupName, String cloudServiceName, Context context) {
        return beginDeleteAsync(roleInstanceName, resourceGroupName, cloudServiceName, context)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Deletes a role instance from a cloud service.
     *
     * @param roleInstanceName Name of the role instance.
     * @param resourceGroupName The resourceGroupName parameter.
     * @param cloudServiceName The cloudServiceName parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void delete(String roleInstanceName, String resourceGroupName, String cloudServiceName) {
        deleteAsync(roleInstanceName, resourceGroupName, cloudServiceName).block();
    }

    /**
     * Deletes a role instance from a cloud service.
     *
     * @param roleInstanceName Name of the role instance.
     * @param resourceGroupName The resourceGroupName parameter.
     * @param cloudServiceName The cloudServiceName parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void delete(String roleInstanceName, String resourceGroupName, String cloudServiceName, Context context) {
        deleteAsync(roleInstanceName, resourceGroupName, cloudServiceName, context).block();
    }

    /**
     * Gets a role instance from a cloud service.
     *
     * @param roleInstanceName Name of the role instance.
     * @param resourceGroupName The resourceGroupName parameter.
     * @param cloudServiceName The cloudServiceName parameter.
     * @param expand The expand expression to apply to the operation. 'UserData' is not supported for cloud services.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a role instance from a cloud service.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<RoleInstanceInner>> getWithResponseAsync(
        String roleInstanceName, String resourceGroupName, String cloudServiceName, InstanceViewTypes expand) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (roleInstanceName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter roleInstanceName is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (cloudServiceName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter cloudServiceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String apiVersion = "2021-03-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .get(
                            this.client.getEndpoint(),
                            roleInstanceName,
                            resourceGroupName,
                            cloudServiceName,
                            this.client.getSubscriptionId(),
                            apiVersion,
                            expand,
                            accept,
                            context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets a role instance from a cloud service.
     *
     * @param roleInstanceName Name of the role instance.
     * @param resourceGroupName The resourceGroupName parameter.
     * @param cloudServiceName The cloudServiceName parameter.
     * @param expand The expand expression to apply to the operation. 'UserData' is not supported for cloud services.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a role instance from a cloud service.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<RoleInstanceInner>> getWithResponseAsync(
        String roleInstanceName,
        String resourceGroupName,
        String cloudServiceName,
        InstanceViewTypes expand,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (roleInstanceName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter roleInstanceName is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (cloudServiceName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter cloudServiceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String apiVersion = "2021-03-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .get(
                this.client.getEndpoint(),
                roleInstanceName,
                resourceGroupName,
                cloudServiceName,
                this.client.getSubscriptionId(),
                apiVersion,
                expand,
                accept,
                context);
    }

    /**
     * Gets a role instance from a cloud service.
     *
     * @param roleInstanceName Name of the role instance.
     * @param resourceGroupName The resourceGroupName parameter.
     * @param cloudServiceName The cloudServiceName parameter.
     * @param expand The expand expression to apply to the operation. 'UserData' is not supported for cloud services.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a role instance from a cloud service.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<RoleInstanceInner> getAsync(
        String roleInstanceName, String resourceGroupName, String cloudServiceName, InstanceViewTypes expand) {
        return getWithResponseAsync(roleInstanceName, resourceGroupName, cloudServiceName, expand)
            .flatMap(
                (Response<RoleInstanceInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Gets a role instance from a cloud service.
     *
     * @param roleInstanceName Name of the role instance.
     * @param resourceGroupName The resourceGroupName parameter.
     * @param cloudServiceName The cloudServiceName parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a role instance from a cloud service.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<RoleInstanceInner> getAsync(
        String roleInstanceName, String resourceGroupName, String cloudServiceName) {
        final InstanceViewTypes expand = null;
        return getWithResponseAsync(roleInstanceName, resourceGroupName, cloudServiceName, expand)
            .flatMap(
                (Response<RoleInstanceInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Gets a role instance from a cloud service.
     *
     * @param roleInstanceName Name of the role instance.
     * @param resourceGroupName The resourceGroupName parameter.
     * @param cloudServiceName The cloudServiceName parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a role instance from a cloud service.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public RoleInstanceInner get(String roleInstanceName, String resourceGroupName, String cloudServiceName) {
        final InstanceViewTypes expand = null;
        return getAsync(roleInstanceName, resourceGroupName, cloudServiceName, expand).block();
    }

    /**
     * Gets a role instance from a cloud service.
     *
     * @param roleInstanceName Name of the role instance.
     * @param resourceGroupName The resourceGroupName parameter.
     * @param cloudServiceName The cloudServiceName parameter.
     * @param expand The expand expression to apply to the operation. 'UserData' is not supported for cloud services.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a role instance from a cloud service.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<RoleInstanceInner> getWithResponse(
        String roleInstanceName,
        String resourceGroupName,
        String cloudServiceName,
        InstanceViewTypes expand,
        Context context) {
        return getWithResponseAsync(roleInstanceName, resourceGroupName, cloudServiceName, expand, context).block();
    }

    /**
     * Retrieves information about the run-time state of a role instance in a cloud service.
     *
     * @param roleInstanceName Name of the role instance.
     * @param resourceGroupName The resourceGroupName parameter.
     * @param cloudServiceName The cloudServiceName parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the instance view of the role instance.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<RoleInstanceViewInner>> getInstanceViewWithResponseAsync(
        String roleInstanceName, String resourceGroupName, String cloudServiceName) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (roleInstanceName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter roleInstanceName is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (cloudServiceName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter cloudServiceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String apiVersion = "2021-03-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .getInstanceView(
                            this.client.getEndpoint(),
                            roleInstanceName,
                            resourceGroupName,
                            cloudServiceName,
                            this.client.getSubscriptionId(),
                            apiVersion,
                            accept,
                            context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Retrieves information about the run-time state of a role instance in a cloud service.
     *
     * @param roleInstanceName Name of the role instance.
     * @param resourceGroupName The resourceGroupName parameter.
     * @param cloudServiceName The cloudServiceName parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the instance view of the role instance.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<RoleInstanceViewInner>> getInstanceViewWithResponseAsync(
        String roleInstanceName, String resourceGroupName, String cloudServiceName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (roleInstanceName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter roleInstanceName is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (cloudServiceName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter cloudServiceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String apiVersion = "2021-03-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .getInstanceView(
                this.client.getEndpoint(),
                roleInstanceName,
                resourceGroupName,
                cloudServiceName,
                this.client.getSubscriptionId(),
                apiVersion,
                accept,
                context);
    }

    /**
     * Retrieves information about the run-time state of a role instance in a cloud service.
     *
     * @param roleInstanceName Name of the role instance.
     * @param resourceGroupName The resourceGroupName parameter.
     * @param cloudServiceName The cloudServiceName parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the instance view of the role instance.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<RoleInstanceViewInner> getInstanceViewAsync(
        String roleInstanceName, String resourceGroupName, String cloudServiceName) {
        return getInstanceViewWithResponseAsync(roleInstanceName, resourceGroupName, cloudServiceName)
            .flatMap(
                (Response<RoleInstanceViewInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Retrieves information about the run-time state of a role instance in a cloud service.
     *
     * @param roleInstanceName Name of the role instance.
     * @param resourceGroupName The resourceGroupName parameter.
     * @param cloudServiceName The cloudServiceName parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the instance view of the role instance.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public RoleInstanceViewInner getInstanceView(
        String roleInstanceName, String resourceGroupName, String cloudServiceName) {
        return getInstanceViewAsync(roleInstanceName, resourceGroupName, cloudServiceName).block();
    }

    /**
     * Retrieves information about the run-time state of a role instance in a cloud service.
     *
     * @param roleInstanceName Name of the role instance.
     * @param resourceGroupName The resourceGroupName parameter.
     * @param cloudServiceName The cloudServiceName parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the instance view of the role instance.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<RoleInstanceViewInner> getInstanceViewWithResponse(
        String roleInstanceName, String resourceGroupName, String cloudServiceName, Context context) {
        return getInstanceViewWithResponseAsync(roleInstanceName, resourceGroupName, cloudServiceName, context).block();
    }

    /**
     * Gets the list of all role instances in a cloud service. Use nextLink property in the response to get the next
     * page of role instances. Do this till nextLink is null to fetch all the role instances.
     *
     * @param resourceGroupName The resourceGroupName parameter.
     * @param cloudServiceName The cloudServiceName parameter.
     * @param expand The expand expression to apply to the operation. 'UserData' is not supported for cloud services.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the list of all role instances in a cloud service.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<RoleInstanceInner>> listSinglePageAsync(
        String resourceGroupName, String cloudServiceName, InstanceViewTypes expand) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (cloudServiceName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter cloudServiceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String apiVersion = "2021-03-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .list(
                            this.client.getEndpoint(),
                            resourceGroupName,
                            cloudServiceName,
                            this.client.getSubscriptionId(),
                            apiVersion,
                            expand,
                            accept,
                            context))
            .<PagedResponse<RoleInstanceInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets the list of all role instances in a cloud service. Use nextLink property in the response to get the next
     * page of role instances. Do this till nextLink is null to fetch all the role instances.
     *
     * @param resourceGroupName The resourceGroupName parameter.
     * @param cloudServiceName The cloudServiceName parameter.
     * @param expand The expand expression to apply to the operation. 'UserData' is not supported for cloud services.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the list of all role instances in a cloud service.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<RoleInstanceInner>> listSinglePageAsync(
        String resourceGroupName, String cloudServiceName, InstanceViewTypes expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (cloudServiceName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter cloudServiceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String apiVersion = "2021-03-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .list(
                this.client.getEndpoint(),
                resourceGroupName,
                cloudServiceName,
                this.client.getSubscriptionId(),
                apiVersion,
                expand,
                accept,
                context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null));
    }

    /**
     * Gets the list of all role instances in a cloud service. Use nextLink property in the response to get the next
     * page of role instances. Do this till nextLink is null to fetch all the role instances.
     *
     * @param resourceGroupName The resourceGroupName parameter.
     * @param cloudServiceName The cloudServiceName parameter.
     * @param expand The expand expression to apply to the operation. 'UserData' is not supported for cloud services.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the list of all role instances in a cloud service.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<RoleInstanceInner> listAsync(
        String resourceGroupName, String cloudServiceName, InstanceViewTypes expand) {
        return new PagedFlux<>(
            () -> listSinglePageAsync(resourceGroupName, cloudServiceName, expand),
            nextLink -> listNextSinglePageAsync(nextLink));
    }

    /**
     * Gets the list of all role instances in a cloud service. Use nextLink property in the response to get the next
     * page of role instances. Do this till nextLink is null to fetch all the role instances.
     *
     * @param resourceGroupName The resourceGroupName parameter.
     * @param cloudServiceName The cloudServiceName parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the list of all role instances in a cloud service.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<RoleInstanceInner> listAsync(String resourceGroupName, String cloudServiceName) {
        final InstanceViewTypes expand = null;
        return new PagedFlux<>(
            () -> listSinglePageAsync(resourceGroupName, cloudServiceName, expand),
            nextLink -> listNextSinglePageAsync(nextLink));
    }

    /**
     * Gets the list of all role instances in a cloud service. Use nextLink property in the response to get the next
     * page of role instances. Do this till nextLink is null to fetch all the role instances.
     *
     * @param resourceGroupName The resourceGroupName parameter.
     * @param cloudServiceName The cloudServiceName parameter.
     * @param expand The expand expression to apply to the operation. 'UserData' is not supported for cloud services.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the list of all role instances in a cloud service.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<RoleInstanceInner> listAsync(
        String resourceGroupName, String cloudServiceName, InstanceViewTypes expand, Context context) {
        return new PagedFlux<>(
            () -> listSinglePageAsync(resourceGroupName, cloudServiceName, expand, context),
            nextLink -> listNextSinglePageAsync(nextLink, context));
    }

    /**
     * Gets the list of all role instances in a cloud service. Use nextLink property in the response to get the next
     * page of role instances. Do this till nextLink is null to fetch all the role instances.
     *
     * @param resourceGroupName The resourceGroupName parameter.
     * @param cloudServiceName The cloudServiceName parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the list of all role instances in a cloud service.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<RoleInstanceInner> list(String resourceGroupName, String cloudServiceName) {
        final InstanceViewTypes expand = null;
        return new PagedIterable<>(listAsync(resourceGroupName, cloudServiceName, expand));
    }

    /**
     * Gets the list of all role instances in a cloud service. Use nextLink property in the response to get the next
     * page of role instances. Do this till nextLink is null to fetch all the role instances.
     *
     * @param resourceGroupName The resourceGroupName parameter.
     * @param cloudServiceName The cloudServiceName parameter.
     * @param expand The expand expression to apply to the operation. 'UserData' is not supported for cloud services.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the list of all role instances in a cloud service.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<RoleInstanceInner> list(
        String resourceGroupName, String cloudServiceName, InstanceViewTypes expand, Context context) {
        return new PagedIterable<>(listAsync(resourceGroupName, cloudServiceName, expand, context));
    }

    /**
     * The Reboot Role Instance asynchronous operation requests a reboot of a role instance in the cloud service.
     *
     * @param roleInstanceName Name of the role instance.
     * @param resourceGroupName The resourceGroupName parameter.
     * @param cloudServiceName The cloudServiceName parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> restartWithResponseAsync(
        String roleInstanceName, String resourceGroupName, String cloudServiceName) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (roleInstanceName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter roleInstanceName is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (cloudServiceName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter cloudServiceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String apiVersion = "2021-03-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .restart(
                            this.client.getEndpoint(),
                            roleInstanceName,
                            resourceGroupName,
                            cloudServiceName,
                            this.client.getSubscriptionId(),
                            apiVersion,
                            accept,
                            context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * The Reboot Role Instance asynchronous operation requests a reboot of a role instance in the cloud service.
     *
     * @param roleInstanceName Name of the role instance.
     * @param resourceGroupName The resourceGroupName parameter.
     * @param cloudServiceName The cloudServiceName parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> restartWithResponseAsync(
        String roleInstanceName, String resourceGroupName, String cloudServiceName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (roleInstanceName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter roleInstanceName is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (cloudServiceName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter cloudServiceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String apiVersion = "2021-03-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .restart(
                this.client.getEndpoint(),
                roleInstanceName,
                resourceGroupName,
                cloudServiceName,
                this.client.getSubscriptionId(),
                apiVersion,
                accept,
                context);
    }

    /**
     * The Reboot Role Instance asynchronous operation requests a reboot of a role instance in the cloud service.
     *
     * @param roleInstanceName Name of the role instance.
     * @param resourceGroupName The resourceGroupName parameter.
     * @param cloudServiceName The cloudServiceName parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginRestartAsync(
        String roleInstanceName, String resourceGroupName, String cloudServiceName) {
        Mono<Response<Flux<ByteBuffer>>> mono =
            restartWithResponseAsync(roleInstanceName, resourceGroupName, cloudServiceName);
        return this
            .client
            .<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class, Context.NONE);
    }

    /**
     * The Reboot Role Instance asynchronous operation requests a reboot of a role instance in the cloud service.
     *
     * @param roleInstanceName Name of the role instance.
     * @param resourceGroupName The resourceGroupName parameter.
     * @param cloudServiceName The cloudServiceName parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginRestartAsync(
        String roleInstanceName, String resourceGroupName, String cloudServiceName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono =
            restartWithResponseAsync(roleInstanceName, resourceGroupName, cloudServiceName, context);
        return this
            .client
            .<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class, context);
    }

    /**
     * The Reboot Role Instance asynchronous operation requests a reboot of a role instance in the cloud service.
     *
     * @param roleInstanceName Name of the role instance.
     * @param resourceGroupName The resourceGroupName parameter.
     * @param cloudServiceName The cloudServiceName parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginRestart(
        String roleInstanceName, String resourceGroupName, String cloudServiceName) {
        return beginRestartAsync(roleInstanceName, resourceGroupName, cloudServiceName).getSyncPoller();
    }

    /**
     * The Reboot Role Instance asynchronous operation requests a reboot of a role instance in the cloud service.
     *
     * @param roleInstanceName Name of the role instance.
     * @param resourceGroupName The resourceGroupName parameter.
     * @param cloudServiceName The cloudServiceName parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginRestart(
        String roleInstanceName, String resourceGroupName, String cloudServiceName, Context context) {
        return beginRestartAsync(roleInstanceName, resourceGroupName, cloudServiceName, context).getSyncPoller();
    }

    /**
     * The Reboot Role Instance asynchronous operation requests a reboot of a role instance in the cloud service.
     *
     * @param roleInstanceName Name of the role instance.
     * @param resourceGroupName The resourceGroupName parameter.
     * @param cloudServiceName The cloudServiceName parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> restartAsync(String roleInstanceName, String resourceGroupName, String cloudServiceName) {
        return beginRestartAsync(roleInstanceName, resourceGroupName, cloudServiceName)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * The Reboot Role Instance asynchronous operation requests a reboot of a role instance in the cloud service.
     *
     * @param roleInstanceName Name of the role instance.
     * @param resourceGroupName The resourceGroupName parameter.
     * @param cloudServiceName The cloudServiceName parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Void> restartAsync(
        String roleInstanceName, String resourceGroupName, String cloudServiceName, Context context) {
        return beginRestartAsync(roleInstanceName, resourceGroupName, cloudServiceName, context)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * The Reboot Role Instance asynchronous operation requests a reboot of a role instance in the cloud service.
     *
     * @param roleInstanceName Name of the role instance.
     * @param resourceGroupName The resourceGroupName parameter.
     * @param cloudServiceName The cloudServiceName parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void restart(String roleInstanceName, String resourceGroupName, String cloudServiceName) {
        restartAsync(roleInstanceName, resourceGroupName, cloudServiceName).block();
    }

    /**
     * The Reboot Role Instance asynchronous operation requests a reboot of a role instance in the cloud service.
     *
     * @param roleInstanceName Name of the role instance.
     * @param resourceGroupName The resourceGroupName parameter.
     * @param cloudServiceName The cloudServiceName parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void restart(String roleInstanceName, String resourceGroupName, String cloudServiceName, Context context) {
        restartAsync(roleInstanceName, resourceGroupName, cloudServiceName, context).block();
    }

    /**
     * The Reimage Role Instance asynchronous operation reinstalls the operating system on instances of web roles or
     * worker roles.
     *
     * @param roleInstanceName Name of the role instance.
     * @param resourceGroupName The resourceGroupName parameter.
     * @param cloudServiceName The cloudServiceName parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> reimageWithResponseAsync(
        String roleInstanceName, String resourceGroupName, String cloudServiceName) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (roleInstanceName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter roleInstanceName is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (cloudServiceName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter cloudServiceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String apiVersion = "2021-03-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .reimage(
                            this.client.getEndpoint(),
                            roleInstanceName,
                            resourceGroupName,
                            cloudServiceName,
                            this.client.getSubscriptionId(),
                            apiVersion,
                            accept,
                            context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * The Reimage Role Instance asynchronous operation reinstalls the operating system on instances of web roles or
     * worker roles.
     *
     * @param roleInstanceName Name of the role instance.
     * @param resourceGroupName The resourceGroupName parameter.
     * @param cloudServiceName The cloudServiceName parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> reimageWithResponseAsync(
        String roleInstanceName, String resourceGroupName, String cloudServiceName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (roleInstanceName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter roleInstanceName is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (cloudServiceName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter cloudServiceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String apiVersion = "2021-03-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .reimage(
                this.client.getEndpoint(),
                roleInstanceName,
                resourceGroupName,
                cloudServiceName,
                this.client.getSubscriptionId(),
                apiVersion,
                accept,
                context);
    }

    /**
     * The Reimage Role Instance asynchronous operation reinstalls the operating system on instances of web roles or
     * worker roles.
     *
     * @param roleInstanceName Name of the role instance.
     * @param resourceGroupName The resourceGroupName parameter.
     * @param cloudServiceName The cloudServiceName parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginReimageAsync(
        String roleInstanceName, String resourceGroupName, String cloudServiceName) {
        Mono<Response<Flux<ByteBuffer>>> mono =
            reimageWithResponseAsync(roleInstanceName, resourceGroupName, cloudServiceName);
        return this
            .client
            .<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class, Context.NONE);
    }

    /**
     * The Reimage Role Instance asynchronous operation reinstalls the operating system on instances of web roles or
     * worker roles.
     *
     * @param roleInstanceName Name of the role instance.
     * @param resourceGroupName The resourceGroupName parameter.
     * @param cloudServiceName The cloudServiceName parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginReimageAsync(
        String roleInstanceName, String resourceGroupName, String cloudServiceName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono =
            reimageWithResponseAsync(roleInstanceName, resourceGroupName, cloudServiceName, context);
        return this
            .client
            .<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class, context);
    }

    /**
     * The Reimage Role Instance asynchronous operation reinstalls the operating system on instances of web roles or
     * worker roles.
     *
     * @param roleInstanceName Name of the role instance.
     * @param resourceGroupName The resourceGroupName parameter.
     * @param cloudServiceName The cloudServiceName parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginReimage(
        String roleInstanceName, String resourceGroupName, String cloudServiceName) {
        return beginReimageAsync(roleInstanceName, resourceGroupName, cloudServiceName).getSyncPoller();
    }

    /**
     * The Reimage Role Instance asynchronous operation reinstalls the operating system on instances of web roles or
     * worker roles.
     *
     * @param roleInstanceName Name of the role instance.
     * @param resourceGroupName The resourceGroupName parameter.
     * @param cloudServiceName The cloudServiceName parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginReimage(
        String roleInstanceName, String resourceGroupName, String cloudServiceName, Context context) {
        return beginReimageAsync(roleInstanceName, resourceGroupName, cloudServiceName, context).getSyncPoller();
    }

    /**
     * The Reimage Role Instance asynchronous operation reinstalls the operating system on instances of web roles or
     * worker roles.
     *
     * @param roleInstanceName Name of the role instance.
     * @param resourceGroupName The resourceGroupName parameter.
     * @param cloudServiceName The cloudServiceName parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> reimageAsync(String roleInstanceName, String resourceGroupName, String cloudServiceName) {
        return beginReimageAsync(roleInstanceName, resourceGroupName, cloudServiceName)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * The Reimage Role Instance asynchronous operation reinstalls the operating system on instances of web roles or
     * worker roles.
     *
     * @param roleInstanceName Name of the role instance.
     * @param resourceGroupName The resourceGroupName parameter.
     * @param cloudServiceName The cloudServiceName parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Void> reimageAsync(
        String roleInstanceName, String resourceGroupName, String cloudServiceName, Context context) {
        return beginReimageAsync(roleInstanceName, resourceGroupName, cloudServiceName, context)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * The Reimage Role Instance asynchronous operation reinstalls the operating system on instances of web roles or
     * worker roles.
     *
     * @param roleInstanceName Name of the role instance.
     * @param resourceGroupName The resourceGroupName parameter.
     * @param cloudServiceName The cloudServiceName parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void reimage(String roleInstanceName, String resourceGroupName, String cloudServiceName) {
        reimageAsync(roleInstanceName, resourceGroupName, cloudServiceName).block();
    }

    /**
     * The Reimage Role Instance asynchronous operation reinstalls the operating system on instances of web roles or
     * worker roles.
     *
     * @param roleInstanceName Name of the role instance.
     * @param resourceGroupName The resourceGroupName parameter.
     * @param cloudServiceName The cloudServiceName parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void reimage(String roleInstanceName, String resourceGroupName, String cloudServiceName, Context context) {
        reimageAsync(roleInstanceName, resourceGroupName, cloudServiceName, context).block();
    }

    /**
     * The Rebuild Role Instance asynchronous operation reinstalls the operating system on instances of web roles or
     * worker roles and initializes the storage resources that are used by them. If you do not want to initialize
     * storage resources, you can use Reimage Role Instance.
     *
     * @param roleInstanceName Name of the role instance.
     * @param resourceGroupName The resourceGroupName parameter.
     * @param cloudServiceName The cloudServiceName parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> rebuildWithResponseAsync(
        String roleInstanceName, String resourceGroupName, String cloudServiceName) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (roleInstanceName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter roleInstanceName is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (cloudServiceName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter cloudServiceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String apiVersion = "2021-03-01";
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .rebuild(
                            this.client.getEndpoint(),
                            roleInstanceName,
                            resourceGroupName,
                            cloudServiceName,
                            this.client.getSubscriptionId(),
                            apiVersion,
                            accept,
                            context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * The Rebuild Role Instance asynchronous operation reinstalls the operating system on instances of web roles or
     * worker roles and initializes the storage resources that are used by them. If you do not want to initialize
     * storage resources, you can use Reimage Role Instance.
     *
     * @param roleInstanceName Name of the role instance.
     * @param resourceGroupName The resourceGroupName parameter.
     * @param cloudServiceName The cloudServiceName parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> rebuildWithResponseAsync(
        String roleInstanceName, String resourceGroupName, String cloudServiceName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (roleInstanceName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter roleInstanceName is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (cloudServiceName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter cloudServiceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String apiVersion = "2021-03-01";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .rebuild(
                this.client.getEndpoint(),
                roleInstanceName,
                resourceGroupName,
                cloudServiceName,
                this.client.getSubscriptionId(),
                apiVersion,
                accept,
                context);
    }

    /**
     * The Rebuild Role Instance asynchronous operation reinstalls the operating system on instances of web roles or
     * worker roles and initializes the storage resources that are used by them. If you do not want to initialize
     * storage resources, you can use Reimage Role Instance.
     *
     * @param roleInstanceName Name of the role instance.
     * @param resourceGroupName The resourceGroupName parameter.
     * @param cloudServiceName The cloudServiceName parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginRebuildAsync(
        String roleInstanceName, String resourceGroupName, String cloudServiceName) {
        Mono<Response<Flux<ByteBuffer>>> mono =
            rebuildWithResponseAsync(roleInstanceName, resourceGroupName, cloudServiceName);
        return this
            .client
            .<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class, Context.NONE);
    }

    /**
     * The Rebuild Role Instance asynchronous operation reinstalls the operating system on instances of web roles or
     * worker roles and initializes the storage resources that are used by them. If you do not want to initialize
     * storage resources, you can use Reimage Role Instance.
     *
     * @param roleInstanceName Name of the role instance.
     * @param resourceGroupName The resourceGroupName parameter.
     * @param cloudServiceName The cloudServiceName parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginRebuildAsync(
        String roleInstanceName, String resourceGroupName, String cloudServiceName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono =
            rebuildWithResponseAsync(roleInstanceName, resourceGroupName, cloudServiceName, context);
        return this
            .client
            .<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class, context);
    }

    /**
     * The Rebuild Role Instance asynchronous operation reinstalls the operating system on instances of web roles or
     * worker roles and initializes the storage resources that are used by them. If you do not want to initialize
     * storage resources, you can use Reimage Role Instance.
     *
     * @param roleInstanceName Name of the role instance.
     * @param resourceGroupName The resourceGroupName parameter.
     * @param cloudServiceName The cloudServiceName parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginRebuild(
        String roleInstanceName, String resourceGroupName, String cloudServiceName) {
        return beginRebuildAsync(roleInstanceName, resourceGroupName, cloudServiceName).getSyncPoller();
    }

    /**
     * The Rebuild Role Instance asynchronous operation reinstalls the operating system on instances of web roles or
     * worker roles and initializes the storage resources that are used by them. If you do not want to initialize
     * storage resources, you can use Reimage Role Instance.
     *
     * @param roleInstanceName Name of the role instance.
     * @param resourceGroupName The resourceGroupName parameter.
     * @param cloudServiceName The cloudServiceName parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginRebuild(
        String roleInstanceName, String resourceGroupName, String cloudServiceName, Context context) {
        return beginRebuildAsync(roleInstanceName, resourceGroupName, cloudServiceName, context).getSyncPoller();
    }

    /**
     * The Rebuild Role Instance asynchronous operation reinstalls the operating system on instances of web roles or
     * worker roles and initializes the storage resources that are used by them. If you do not want to initialize
     * storage resources, you can use Reimage Role Instance.
     *
     * @param roleInstanceName Name of the role instance.
     * @param resourceGroupName The resourceGroupName parameter.
     * @param cloudServiceName The cloudServiceName parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> rebuildAsync(String roleInstanceName, String resourceGroupName, String cloudServiceName) {
        return beginRebuildAsync(roleInstanceName, resourceGroupName, cloudServiceName)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * The Rebuild Role Instance asynchronous operation reinstalls the operating system on instances of web roles or
     * worker roles and initializes the storage resources that are used by them. If you do not want to initialize
     * storage resources, you can use Reimage Role Instance.
     *
     * @param roleInstanceName Name of the role instance.
     * @param resourceGroupName The resourceGroupName parameter.
     * @param cloudServiceName The cloudServiceName parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Void> rebuildAsync(
        String roleInstanceName, String resourceGroupName, String cloudServiceName, Context context) {
        return beginRebuildAsync(roleInstanceName, resourceGroupName, cloudServiceName, context)
            .last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * The Rebuild Role Instance asynchronous operation reinstalls the operating system on instances of web roles or
     * worker roles and initializes the storage resources that are used by them. If you do not want to initialize
     * storage resources, you can use Reimage Role Instance.
     *
     * @param roleInstanceName Name of the role instance.
     * @param resourceGroupName The resourceGroupName parameter.
     * @param cloudServiceName The cloudServiceName parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void rebuild(String roleInstanceName, String resourceGroupName, String cloudServiceName) {
        rebuildAsync(roleInstanceName, resourceGroupName, cloudServiceName).block();
    }

    /**
     * The Rebuild Role Instance asynchronous operation reinstalls the operating system on instances of web roles or
     * worker roles and initializes the storage resources that are used by them. If you do not want to initialize
     * storage resources, you can use Reimage Role Instance.
     *
     * @param roleInstanceName Name of the role instance.
     * @param resourceGroupName The resourceGroupName parameter.
     * @param cloudServiceName The cloudServiceName parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void rebuild(String roleInstanceName, String resourceGroupName, String cloudServiceName, Context context) {
        rebuildAsync(roleInstanceName, resourceGroupName, cloudServiceName, context).block();
    }

    /**
     * Gets a remote desktop file for a role instance in a cloud service.
     *
     * @param roleInstanceName Name of the role instance.
     * @param resourceGroupName The resourceGroupName parameter.
     * @param cloudServiceName The cloudServiceName parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a remote desktop file for a role instance in a cloud service.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<StreamResponse> getRemoteDesktopFileWithResponseAsync(
        String roleInstanceName, String resourceGroupName, String cloudServiceName) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (roleInstanceName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter roleInstanceName is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (cloudServiceName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter cloudServiceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String apiVersion = "2021-03-01";
        final String accept = "application/x-rdp";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .getRemoteDesktopFile(
                            this.client.getEndpoint(),
                            roleInstanceName,
                            resourceGroupName,
                            cloudServiceName,
                            this.client.getSubscriptionId(),
                            apiVersion,
                            accept,
                            context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Gets a remote desktop file for a role instance in a cloud service.
     *
     * @param roleInstanceName Name of the role instance.
     * @param resourceGroupName The resourceGroupName parameter.
     * @param cloudServiceName The cloudServiceName parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a remote desktop file for a role instance in a cloud service.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<StreamResponse> getRemoteDesktopFileWithResponseAsync(
        String roleInstanceName, String resourceGroupName, String cloudServiceName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (roleInstanceName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter roleInstanceName is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (cloudServiceName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter cloudServiceName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        final String apiVersion = "2021-03-01";
        final String accept = "application/x-rdp";
        context = this.client.mergeContext(context);
        return service
            .getRemoteDesktopFile(
                this.client.getEndpoint(),
                roleInstanceName,
                resourceGroupName,
                cloudServiceName,
                this.client.getSubscriptionId(),
                apiVersion,
                accept,
                context);
    }

    /**
     * Gets a remote desktop file for a role instance in a cloud service.
     *
     * @param roleInstanceName Name of the role instance.
     * @param resourceGroupName The resourceGroupName parameter.
     * @param cloudServiceName The cloudServiceName parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a remote desktop file for a role instance in a cloud service.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Flux<ByteBuffer> getRemoteDesktopFileAsync(
        String roleInstanceName, String resourceGroupName, String cloudServiceName) {
        return getRemoteDesktopFileWithResponseAsync(roleInstanceName, resourceGroupName, cloudServiceName)
            .flatMapMany(StreamResponse::getValue);
    }

    /**
     * Gets a remote desktop file for a role instance in a cloud service.
     *
     * @param roleInstanceName Name of the role instance.
     * @param resourceGroupName The resourceGroupName parameter.
     * @param cloudServiceName The cloudServiceName parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a remote desktop file for a role instance in a cloud service.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public InputStream getRemoteDesktopFile(
        String roleInstanceName, String resourceGroupName, String cloudServiceName) {
        Iterator<ByteBufferBackedInputStream> iterator =
            getRemoteDesktopFileAsync(roleInstanceName, resourceGroupName, cloudServiceName)
                .map(ByteBufferBackedInputStream::new)
                .toStream()
                .iterator();
        Enumeration<InputStream> enumeration =
            new Enumeration<InputStream>() {
                @Override
                public boolean hasMoreElements() {
                    return iterator.hasNext();
                }

                @Override
                public InputStream nextElement() {
                    return iterator.next();
                }
            };
        return new SequenceInputStream(enumeration);
    }

    /**
     * Gets a remote desktop file for a role instance in a cloud service.
     *
     * @param roleInstanceName Name of the role instance.
     * @param resourceGroupName The resourceGroupName parameter.
     * @param cloudServiceName The cloudServiceName parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a remote desktop file for a role instance in a cloud service.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public StreamResponse getRemoteDesktopFileWithResponse(
        String roleInstanceName, String resourceGroupName, String cloudServiceName, Context context) {
        return getRemoteDesktopFileWithResponseAsync(roleInstanceName, resourceGroupName, cloudServiceName, context)
            .block();
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<RoleInstanceInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listNext(nextLink, this.client.getEndpoint(), accept, context))
            .<PagedResponse<RoleInstanceInner>>map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the next page of items.
     *
     * @param nextLink The nextLink parameter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<RoleInstanceInner>> listNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(
                res ->
                    new PagedResponseBase<>(
                        res.getRequest(),
                        res.getStatusCode(),
                        res.getHeaders(),
                        res.getValue().value(),
                        res.getValue().nextLink(),
                        null));
    }
}
