// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/** Defines values for IpVersions. */
public final class IpVersions extends ExpandableStringEnum<IpVersions> {
    /** Static value IPv4 for IpVersions. */
    public static final IpVersions IPV4 = fromString("IPv4");

    /** Static value IPv6 for IpVersions. */
    public static final IpVersions IPV6 = fromString("IPv6");

    /**
     * Creates or finds a IpVersions from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding IpVersions.
     */
    @JsonCreator
    public static IpVersions fromString(String name) {
        return fromString(name, IpVersions.class);
    }

    /** @return known IpVersions values. */
    public static Collection<IpVersions> values() {
        return values(IpVersions.class);
    }
}
