// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Properties of the disk for which update is pending. */
@Fluent
public final class PropertyUpdatesInProgress {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(PropertyUpdatesInProgress.class);

    /*
     * The target performance tier of the disk if a tier change operation is in
     * progress.
     */
    @JsonProperty(value = "targetTier")
    private String targetTier;

    /**
     * Get the targetTier property: The target performance tier of the disk if a tier change operation is in progress.
     *
     * @return the targetTier value.
     */
    public String targetTier() {
        return this.targetTier;
    }

    /**
     * Set the targetTier property: The target performance tier of the disk if a tier change operation is in progress.
     *
     * @param targetTier the targetTier value to set.
     * @return the PropertyUpdatesInProgress object itself.
     */
    public PropertyUpdatesInProgress withTargetTier(String targetTier) {
        this.targetTier = targetTier;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
