// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/** Defines values for PublicIpAllocationMethod. */
public final class PublicIpAllocationMethod extends ExpandableStringEnum<PublicIpAllocationMethod> {
    /** Static value Dynamic for PublicIpAllocationMethod. */
    public static final PublicIpAllocationMethod DYNAMIC = fromString("Dynamic");

    /** Static value Static for PublicIpAllocationMethod. */
    public static final PublicIpAllocationMethod STATIC = fromString("Static");

    /**
     * Creates or finds a PublicIpAllocationMethod from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding PublicIpAllocationMethod.
     */
    @JsonCreator
    public static PublicIpAllocationMethod fromString(String name) {
        return fromString(name, PublicIpAllocationMethod.class);
    }

    /** @return known PublicIpAllocationMethod values. */
    public static Collection<PublicIpAllocationMethod> values() {
        return values(PublicIpAllocationMethod.class);
    }
}
