// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

/** List of supported capabilities (like accelerated networking) persisted on the disk resource for VM use. */
@Fluent
public final class SupportedCapabilities {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(SupportedCapabilities.class);

    /*
     * True if the image from which the OS disk is created supports accelerated
     * networking.
     */
    @JsonProperty(value = "acceleratedNetwork")
    private Boolean acceleratedNetwork;

    /**
     * Get the acceleratedNetwork property: True if the image from which the OS disk is created supports accelerated
     * networking.
     *
     * @return the acceleratedNetwork value.
     */
    public Boolean acceleratedNetwork() {
        return this.acceleratedNetwork;
    }

    /**
     * Set the acceleratedNetwork property: True if the image from which the OS disk is created supports accelerated
     * networking.
     *
     * @param acceleratedNetwork the acceleratedNetwork value to set.
     * @return the SupportedCapabilities object itself.
     */
    public SupportedCapabilities withAcceleratedNetwork(Boolean acceleratedNetwork) {
        this.acceleratedNetwork = acceleratedNetwork;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
