// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/** Defines values for WindowsVMGuestPatchMode. */
public final class WindowsVMGuestPatchMode extends ExpandableStringEnum<WindowsVMGuestPatchMode> {
    /** Static value Manual for WindowsVMGuestPatchMode. */
    public static final WindowsVMGuestPatchMode MANUAL = fromString("Manual");

    /** Static value AutomaticByOS for WindowsVMGuestPatchMode. */
    public static final WindowsVMGuestPatchMode AUTOMATIC_BY_OS = fromString("AutomaticByOS");

    /** Static value AutomaticByPlatform for WindowsVMGuestPatchMode. */
    public static final WindowsVMGuestPatchMode AUTOMATIC_BY_PLATFORM = fromString("AutomaticByPlatform");

    /**
     * Creates or finds a WindowsVMGuestPatchMode from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding WindowsVMGuestPatchMode.
     */
    @JsonCreator
    public static WindowsVMGuestPatchMode fromString(String name) {
        return fromString(name, WindowsVMGuestPatchMode.class);
    }

    /** @return known WindowsVMGuestPatchMode values. */
    public static Collection<WindowsVMGuestPatchMode> values() {
        return values(WindowsVMGuestPatchMode.class);
    }
}
