/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.compute.fluent.DiskRestorePointsClient;
import com.azure.resourcemanager.compute.fluent.models.AccessUriInner;
import com.azure.resourcemanager.compute.fluent.models.DiskRestorePointInner;
import com.azure.resourcemanager.compute.implementation.ComputeManagementClientImpl;
import com.azure.resourcemanager.compute.models.ApiErrorException;
import com.azure.resourcemanager.compute.models.DiskRestorePointList;
import com.azure.resourcemanager.compute.models.GrantAccessData;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class DiskRestorePointsClientImpl
implements DiskRestorePointsClient {
    private final ClientLogger logger = new ClientLogger(DiskRestorePointsClientImpl.class);
    private final DiskRestorePointsService service;
    private final ComputeManagementClientImpl client;

    DiskRestorePointsClientImpl(ComputeManagementClientImpl client) {
        this.service = (DiskRestorePointsService)RestProxy.create(DiskRestorePointsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<DiskRestorePointInner>> getWithResponseAsync(String resourceGroupName, String restorePointCollectionName, String vmRestorePointName, String diskRestorePointName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (restorePointCollectionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter restorePointCollectionName is required and cannot be null."));
        }
        if (vmRestorePointName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vmRestorePointName is required and cannot be null."));
        }
        if (diskRestorePointName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter diskRestorePointName is required and cannot be null."));
        }
        String apiVersion = "2021-04-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, restorePointCollectionName, vmRestorePointName, diskRestorePointName, "2021-04-01", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<DiskRestorePointInner>> getWithResponseAsync(String resourceGroupName, String restorePointCollectionName, String vmRestorePointName, String diskRestorePointName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (restorePointCollectionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter restorePointCollectionName is required and cannot be null."));
        }
        if (vmRestorePointName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vmRestorePointName is required and cannot be null."));
        }
        if (diskRestorePointName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter diskRestorePointName is required and cannot be null."));
        }
        String apiVersion = "2021-04-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, restorePointCollectionName, vmRestorePointName, diskRestorePointName, "2021-04-01", "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DiskRestorePointInner> getAsync(String resourceGroupName, String restorePointCollectionName, String vmRestorePointName, String diskRestorePointName) {
        return this.getWithResponseAsync(resourceGroupName, restorePointCollectionName, vmRestorePointName, diskRestorePointName).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((DiskRestorePointInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DiskRestorePointInner get(String resourceGroupName, String restorePointCollectionName, String vmRestorePointName, String diskRestorePointName) {
        return (DiskRestorePointInner)this.getAsync(resourceGroupName, restorePointCollectionName, vmRestorePointName, diskRestorePointName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DiskRestorePointInner> getWithResponse(String resourceGroupName, String restorePointCollectionName, String vmRestorePointName, String diskRestorePointName, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, restorePointCollectionName, vmRestorePointName, diskRestorePointName, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<DiskRestorePointInner>> listByRestorePointSinglePageAsync(String resourceGroupName, String restorePointCollectionName, String vmRestorePointName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (restorePointCollectionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter restorePointCollectionName is required and cannot be null."));
        }
        if (vmRestorePointName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vmRestorePointName is required and cannot be null."));
        }
        String apiVersion = "2021-04-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByRestorePoint(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, restorePointCollectionName, vmRestorePointName, "2021-04-01", "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DiskRestorePointList)res.getValue()).value(), ((DiskRestorePointList)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<DiskRestorePointInner>> listByRestorePointSinglePageAsync(String resourceGroupName, String restorePointCollectionName, String vmRestorePointName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (restorePointCollectionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter restorePointCollectionName is required and cannot be null."));
        }
        if (vmRestorePointName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vmRestorePointName is required and cannot be null."));
        }
        String apiVersion = "2021-04-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByRestorePoint(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, restorePointCollectionName, vmRestorePointName, "2021-04-01", "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DiskRestorePointList)res.getValue()).value(), ((DiskRestorePointList)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<DiskRestorePointInner> listByRestorePointAsync(String resourceGroupName, String restorePointCollectionName, String vmRestorePointName) {
        return new PagedFlux(() -> this.listByRestorePointSinglePageAsync(resourceGroupName, restorePointCollectionName, vmRestorePointName), nextLink -> this.listByRestorePointNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<DiskRestorePointInner> listByRestorePointAsync(String resourceGroupName, String restorePointCollectionName, String vmRestorePointName, Context context) {
        return new PagedFlux(() -> this.listByRestorePointSinglePageAsync(resourceGroupName, restorePointCollectionName, vmRestorePointName, context), nextLink -> this.listByRestorePointNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DiskRestorePointInner> listByRestorePoint(String resourceGroupName, String restorePointCollectionName, String vmRestorePointName) {
        return new PagedIterable(this.listByRestorePointAsync(resourceGroupName, restorePointCollectionName, vmRestorePointName));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DiskRestorePointInner> listByRestorePoint(String resourceGroupName, String restorePointCollectionName, String vmRestorePointName, Context context) {
        return new PagedIterable(this.listByRestorePointAsync(resourceGroupName, restorePointCollectionName, vmRestorePointName, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> grantAccessWithResponseAsync(String resourceGroupName, String restorePointCollectionName, String vmRestorePointName, String diskRestorePointName, GrantAccessData grantAccessData) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (restorePointCollectionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter restorePointCollectionName is required and cannot be null."));
        }
        if (vmRestorePointName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vmRestorePointName is required and cannot be null."));
        }
        if (diskRestorePointName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter diskRestorePointName is required and cannot be null."));
        }
        if (grantAccessData == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter grantAccessData is required and cannot be null."));
        }
        grantAccessData.validate();
        String apiVersion = "2021-04-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.grantAccess(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, restorePointCollectionName, vmRestorePointName, diskRestorePointName, "2021-04-01", grantAccessData, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> grantAccessWithResponseAsync(String resourceGroupName, String restorePointCollectionName, String vmRestorePointName, String diskRestorePointName, GrantAccessData grantAccessData, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (restorePointCollectionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter restorePointCollectionName is required and cannot be null."));
        }
        if (vmRestorePointName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vmRestorePointName is required and cannot be null."));
        }
        if (diskRestorePointName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter diskRestorePointName is required and cannot be null."));
        }
        if (grantAccessData == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter grantAccessData is required and cannot be null."));
        }
        grantAccessData.validate();
        String apiVersion = "2021-04-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.grantAccess(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, restorePointCollectionName, vmRestorePointName, diskRestorePointName, "2021-04-01", grantAccessData, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<AccessUriInner>, AccessUriInner> beginGrantAccessAsync(String resourceGroupName, String restorePointCollectionName, String vmRestorePointName, String diskRestorePointName, GrantAccessData grantAccessData) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.grantAccessWithResponseAsync(resourceGroupName, restorePointCollectionName, vmRestorePointName, diskRestorePointName, grantAccessData);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)AccessUriInner.class), (Type)((Object)AccessUriInner.class), Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<AccessUriInner>, AccessUriInner> beginGrantAccessAsync(String resourceGroupName, String restorePointCollectionName, String vmRestorePointName, String diskRestorePointName, GrantAccessData grantAccessData, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.grantAccessWithResponseAsync(resourceGroupName, restorePointCollectionName, vmRestorePointName, diskRestorePointName, grantAccessData, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)AccessUriInner.class), (Type)((Object)AccessUriInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<AccessUriInner>, AccessUriInner> beginGrantAccess(String resourceGroupName, String restorePointCollectionName, String vmRestorePointName, String diskRestorePointName, GrantAccessData grantAccessData) {
        return this.beginGrantAccessAsync(resourceGroupName, restorePointCollectionName, vmRestorePointName, diskRestorePointName, grantAccessData).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<AccessUriInner>, AccessUriInner> beginGrantAccess(String resourceGroupName, String restorePointCollectionName, String vmRestorePointName, String diskRestorePointName, GrantAccessData grantAccessData, Context context) {
        return this.beginGrantAccessAsync(resourceGroupName, restorePointCollectionName, vmRestorePointName, diskRestorePointName, grantAccessData, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AccessUriInner> grantAccessAsync(String resourceGroupName, String restorePointCollectionName, String vmRestorePointName, String diskRestorePointName, GrantAccessData grantAccessData) {
        return this.beginGrantAccessAsync(resourceGroupName, restorePointCollectionName, vmRestorePointName, diskRestorePointName, grantAccessData).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<AccessUriInner> grantAccessAsync(String resourceGroupName, String restorePointCollectionName, String vmRestorePointName, String diskRestorePointName, GrantAccessData grantAccessData, Context context) {
        return this.beginGrantAccessAsync(resourceGroupName, restorePointCollectionName, vmRestorePointName, diskRestorePointName, grantAccessData, context).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public AccessUriInner grantAccess(String resourceGroupName, String restorePointCollectionName, String vmRestorePointName, String diskRestorePointName, GrantAccessData grantAccessData) {
        return (AccessUriInner)this.grantAccessAsync(resourceGroupName, restorePointCollectionName, vmRestorePointName, diskRestorePointName, grantAccessData).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public AccessUriInner grantAccess(String resourceGroupName, String restorePointCollectionName, String vmRestorePointName, String diskRestorePointName, GrantAccessData grantAccessData, Context context) {
        return (AccessUriInner)this.grantAccessAsync(resourceGroupName, restorePointCollectionName, vmRestorePointName, diskRestorePointName, grantAccessData, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> revokeAccessWithResponseAsync(String resourceGroupName, String restorePointCollectionName, String vmRestorePointName, String diskRestorePointName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (restorePointCollectionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter restorePointCollectionName is required and cannot be null."));
        }
        if (vmRestorePointName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vmRestorePointName is required and cannot be null."));
        }
        if (diskRestorePointName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter diskRestorePointName is required and cannot be null."));
        }
        String apiVersion = "2021-04-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.revokeAccess(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, restorePointCollectionName, vmRestorePointName, diskRestorePointName, "2021-04-01", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> revokeAccessWithResponseAsync(String resourceGroupName, String restorePointCollectionName, String vmRestorePointName, String diskRestorePointName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (restorePointCollectionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter restorePointCollectionName is required and cannot be null."));
        }
        if (vmRestorePointName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter vmRestorePointName is required and cannot be null."));
        }
        if (diskRestorePointName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter diskRestorePointName is required and cannot be null."));
        }
        String apiVersion = "2021-04-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.revokeAccess(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, restorePointCollectionName, vmRestorePointName, diskRestorePointName, "2021-04-01", "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginRevokeAccessAsync(String resourceGroupName, String restorePointCollectionName, String vmRestorePointName, String diskRestorePointName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.revokeAccessWithResponseAsync(resourceGroupName, restorePointCollectionName, vmRestorePointName, diskRestorePointName);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginRevokeAccessAsync(String resourceGroupName, String restorePointCollectionName, String vmRestorePointName, String diskRestorePointName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.revokeAccessWithResponseAsync(resourceGroupName, restorePointCollectionName, vmRestorePointName, diskRestorePointName, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginRevokeAccess(String resourceGroupName, String restorePointCollectionName, String vmRestorePointName, String diskRestorePointName) {
        return this.beginRevokeAccessAsync(resourceGroupName, restorePointCollectionName, vmRestorePointName, diskRestorePointName).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginRevokeAccess(String resourceGroupName, String restorePointCollectionName, String vmRestorePointName, String diskRestorePointName, Context context) {
        return this.beginRevokeAccessAsync(resourceGroupName, restorePointCollectionName, vmRestorePointName, diskRestorePointName, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> revokeAccessAsync(String resourceGroupName, String restorePointCollectionName, String vmRestorePointName, String diskRestorePointName) {
        return this.beginRevokeAccessAsync(resourceGroupName, restorePointCollectionName, vmRestorePointName, diskRestorePointName).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> revokeAccessAsync(String resourceGroupName, String restorePointCollectionName, String vmRestorePointName, String diskRestorePointName, Context context) {
        return this.beginRevokeAccessAsync(resourceGroupName, restorePointCollectionName, vmRestorePointName, diskRestorePointName, context).last().flatMap(arg_0 -> ((ComputeManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void revokeAccess(String resourceGroupName, String restorePointCollectionName, String vmRestorePointName, String diskRestorePointName) {
        this.revokeAccessAsync(resourceGroupName, restorePointCollectionName, vmRestorePointName, diskRestorePointName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void revokeAccess(String resourceGroupName, String restorePointCollectionName, String vmRestorePointName, String diskRestorePointName, Context context) {
        this.revokeAccessAsync(resourceGroupName, restorePointCollectionName, vmRestorePointName, diskRestorePointName, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<DiskRestorePointInner>> listByRestorePointNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByRestorePointNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DiskRestorePointList)res.getValue()).value(), ((DiskRestorePointList)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<DiskRestorePointInner>> listByRestorePointNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByRestorePointNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((DiskRestorePointList)res.getValue()).value(), ((DiskRestorePointList)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="ComputeManagementCli")
    private static interface DiskRestorePointsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/restorePointCollections/{restorePointCollectionName}/restorePoints/{vmRestorePointName}/diskRestorePoints/{diskRestorePointName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ApiErrorException.class)
        public Mono<Response<DiskRestorePointInner>> get(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="restorePointCollectionName") String var4, @PathParam(value="vmRestorePointName") String var5, @PathParam(value="diskRestorePointName") String var6, @QueryParam(value="api-version") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/restorePointCollections/{restorePointCollectionName}/restorePoints/{vmRestorePointName}/diskRestorePoints")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ApiErrorException.class)
        public Mono<Response<DiskRestorePointList>> listByRestorePoint(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="restorePointCollectionName") String var4, @PathParam(value="vmRestorePointName") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/restorePointCollections/{restorePointCollectionName}/restorePoints/{vmRestorePointName}/diskRestorePoints/{diskRestorePointName}/beginGetAccess")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ApiErrorException.class)
        public Mono<Response<Flux<ByteBuffer>>> grantAccess(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="restorePointCollectionName") String var4, @PathParam(value="vmRestorePointName") String var5, @PathParam(value="diskRestorePointName") String var6, @QueryParam(value="api-version") String var7, @BodyParam(value="application/json") GrantAccessData var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/restorePointCollections/{restorePointCollectionName}/restorePoints/{vmRestorePointName}/diskRestorePoints/{diskRestorePointName}/endGetAccess")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ApiErrorException.class)
        public Mono<Response<Flux<ByteBuffer>>> revokeAccess(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="restorePointCollectionName") String var4, @PathParam(value="vmRestorePointName") String var5, @PathParam(value="diskRestorePointName") String var6, @QueryParam(value="api-version") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ApiErrorException.class)
        public Mono<Response<DiskRestorePointList>> listByRestorePointNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

