/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerinstance.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.containerinstance.fluent.models.ContainerProperties;
import com.azure.resourcemanager.containerinstance.models.ContainerPort;
import com.azure.resourcemanager.containerinstance.models.ContainerProbe;
import com.azure.resourcemanager.containerinstance.models.ContainerPropertiesInstanceView;
import com.azure.resourcemanager.containerinstance.models.EnvironmentVariable;
import com.azure.resourcemanager.containerinstance.models.ResourceRequirements;
import com.azure.resourcemanager.containerinstance.models.VolumeMount;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class Container {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(Container.class);
    @JsonProperty(value="name", required=true)
    private String name;
    @JsonProperty(value="properties", required=true)
    private ContainerProperties innerProperties = new ContainerProperties();

    public String name() {
        return this.name;
    }

    public Container withName(String name) {
        this.name = name;
        return this;
    }

    private ContainerProperties innerProperties() {
        return this.innerProperties;
    }

    public String image() {
        return this.innerProperties() == null ? null : this.innerProperties().image();
    }

    public Container withImage(String image) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ContainerProperties();
        }
        this.innerProperties().withImage(image);
        return this;
    }

    public List<String> command() {
        return this.innerProperties() == null ? null : this.innerProperties().command();
    }

    public Container withCommand(List<String> command) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ContainerProperties();
        }
        this.innerProperties().withCommand(command);
        return this;
    }

    public List<ContainerPort> ports() {
        return this.innerProperties() == null ? null : this.innerProperties().ports();
    }

    public Container withPorts(List<ContainerPort> ports) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ContainerProperties();
        }
        this.innerProperties().withPorts(ports);
        return this;
    }

    public List<EnvironmentVariable> environmentVariables() {
        return this.innerProperties() == null ? null : this.innerProperties().environmentVariables();
    }

    public Container withEnvironmentVariables(List<EnvironmentVariable> environmentVariables) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ContainerProperties();
        }
        this.innerProperties().withEnvironmentVariables(environmentVariables);
        return this;
    }

    public ContainerPropertiesInstanceView instanceView() {
        return this.innerProperties() == null ? null : this.innerProperties().instanceView();
    }

    public ResourceRequirements resources() {
        return this.innerProperties() == null ? null : this.innerProperties().resources();
    }

    public Container withResources(ResourceRequirements resources) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ContainerProperties();
        }
        this.innerProperties().withResources(resources);
        return this;
    }

    public List<VolumeMount> volumeMounts() {
        return this.innerProperties() == null ? null : this.innerProperties().volumeMounts();
    }

    public Container withVolumeMounts(List<VolumeMount> volumeMounts) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ContainerProperties();
        }
        this.innerProperties().withVolumeMounts(volumeMounts);
        return this;
    }

    public ContainerProbe livenessProbe() {
        return this.innerProperties() == null ? null : this.innerProperties().livenessProbe();
    }

    public Container withLivenessProbe(ContainerProbe livenessProbe) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ContainerProperties();
        }
        this.innerProperties().withLivenessProbe(livenessProbe);
        return this;
    }

    public ContainerProbe readinessProbe() {
        return this.innerProperties() == null ? null : this.innerProperties().readinessProbe();
    }

    public Container withReadinessProbe(ContainerProbe readinessProbe) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ContainerProperties();
        }
        this.innerProperties().withReadinessProbe(readinessProbe);
        return this;
    }

    public void validate() {
        if (this.name() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property name in model Container"));
        }
        if (this.innerProperties() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property innerProperties in model Container"));
        }
        this.innerProperties().validate();
    }
}

