/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerinstance.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.containerinstance.fluent.models.ContainerGroupProperties;
import com.azure.resourcemanager.containerinstance.models.Container;
import com.azure.resourcemanager.containerinstance.models.ContainerGroupDiagnostics;
import com.azure.resourcemanager.containerinstance.models.ContainerGroupIdentity;
import com.azure.resourcemanager.containerinstance.models.ContainerGroupPropertiesInstanceView;
import com.azure.resourcemanager.containerinstance.models.ContainerGroupRestartPolicy;
import com.azure.resourcemanager.containerinstance.models.ContainerGroupSku;
import com.azure.resourcemanager.containerinstance.models.ContainerGroupSubnetId;
import com.azure.resourcemanager.containerinstance.models.DnsConfiguration;
import com.azure.resourcemanager.containerinstance.models.EncryptionProperties;
import com.azure.resourcemanager.containerinstance.models.ImageRegistryCredential;
import com.azure.resourcemanager.containerinstance.models.InitContainerDefinition;
import com.azure.resourcemanager.containerinstance.models.IpAddress;
import com.azure.resourcemanager.containerinstance.models.OperatingSystemTypes;
import com.azure.resourcemanager.containerinstance.models.Volume;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

public final class ContainerGroupInner
extends Resource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(ContainerGroupInner.class);
    @JsonProperty(value="identity")
    private ContainerGroupIdentity identity;
    @JsonProperty(value="properties", required=true)
    private ContainerGroupProperties innerProperties = new ContainerGroupProperties();
    @JsonProperty(value="zones")
    private List<String> zones;

    public ContainerGroupIdentity identity() {
        return this.identity;
    }

    public ContainerGroupInner withIdentity(ContainerGroupIdentity identity) {
        this.identity = identity;
        return this;
    }

    private ContainerGroupProperties innerProperties() {
        return this.innerProperties;
    }

    public List<String> zones() {
        return this.zones;
    }

    public ContainerGroupInner withZones(List<String> zones) {
        this.zones = zones;
        return this;
    }

    public ContainerGroupInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public ContainerGroupInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public String provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public List<Container> containers() {
        return this.innerProperties() == null ? null : this.innerProperties().containers();
    }

    public ContainerGroupInner withContainers(List<Container> containers) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ContainerGroupProperties();
        }
        this.innerProperties().withContainers(containers);
        return this;
    }

    public List<ImageRegistryCredential> imageRegistryCredentials() {
        return this.innerProperties() == null ? null : this.innerProperties().imageRegistryCredentials();
    }

    public ContainerGroupInner withImageRegistryCredentials(List<ImageRegistryCredential> imageRegistryCredentials) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ContainerGroupProperties();
        }
        this.innerProperties().withImageRegistryCredentials(imageRegistryCredentials);
        return this;
    }

    public ContainerGroupRestartPolicy restartPolicy() {
        return this.innerProperties() == null ? null : this.innerProperties().restartPolicy();
    }

    public ContainerGroupInner withRestartPolicy(ContainerGroupRestartPolicy restartPolicy) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ContainerGroupProperties();
        }
        this.innerProperties().withRestartPolicy(restartPolicy);
        return this;
    }

    public IpAddress ipAddress() {
        return this.innerProperties() == null ? null : this.innerProperties().ipAddress();
    }

    public ContainerGroupInner withIpAddress(IpAddress ipAddress) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ContainerGroupProperties();
        }
        this.innerProperties().withIpAddress(ipAddress);
        return this;
    }

    public OperatingSystemTypes osType() {
        return this.innerProperties() == null ? null : this.innerProperties().osType();
    }

    public ContainerGroupInner withOsType(OperatingSystemTypes osType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ContainerGroupProperties();
        }
        this.innerProperties().withOsType(osType);
        return this;
    }

    public List<Volume> volumes() {
        return this.innerProperties() == null ? null : this.innerProperties().volumes();
    }

    public ContainerGroupInner withVolumes(List<Volume> volumes) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ContainerGroupProperties();
        }
        this.innerProperties().withVolumes(volumes);
        return this;
    }

    public ContainerGroupPropertiesInstanceView instanceView() {
        return this.innerProperties() == null ? null : this.innerProperties().instanceView();
    }

    public ContainerGroupDiagnostics diagnostics() {
        return this.innerProperties() == null ? null : this.innerProperties().diagnostics();
    }

    public ContainerGroupInner withDiagnostics(ContainerGroupDiagnostics diagnostics) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ContainerGroupProperties();
        }
        this.innerProperties().withDiagnostics(diagnostics);
        return this;
    }

    public List<ContainerGroupSubnetId> subnetIds() {
        return this.innerProperties() == null ? null : this.innerProperties().subnetIds();
    }

    public ContainerGroupInner withSubnetIds(List<ContainerGroupSubnetId> subnetIds) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ContainerGroupProperties();
        }
        this.innerProperties().withSubnetIds(subnetIds);
        return this;
    }

    public DnsConfiguration dnsConfig() {
        return this.innerProperties() == null ? null : this.innerProperties().dnsConfig();
    }

    public ContainerGroupInner withDnsConfig(DnsConfiguration dnsConfig) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ContainerGroupProperties();
        }
        this.innerProperties().withDnsConfig(dnsConfig);
        return this;
    }

    public ContainerGroupSku sku() {
        return this.innerProperties() == null ? null : this.innerProperties().sku();
    }

    public ContainerGroupInner withSku(ContainerGroupSku sku) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ContainerGroupProperties();
        }
        this.innerProperties().withSku(sku);
        return this;
    }

    public EncryptionProperties encryptionProperties() {
        return this.innerProperties() == null ? null : this.innerProperties().encryptionProperties();
    }

    public ContainerGroupInner withEncryptionProperties(EncryptionProperties encryptionProperties) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ContainerGroupProperties();
        }
        this.innerProperties().withEncryptionProperties(encryptionProperties);
        return this;
    }

    public List<InitContainerDefinition> initContainers() {
        return this.innerProperties() == null ? null : this.innerProperties().initContainers();
    }

    public ContainerGroupInner withInitContainers(List<InitContainerDefinition> initContainers) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ContainerGroupProperties();
        }
        this.innerProperties().withInitContainers(initContainers);
        return this;
    }

    public void validate() {
        if (this.identity() != null) {
            this.identity().validate();
        }
        if (this.innerProperties() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property innerProperties in model ContainerGroupInner"));
        }
        this.innerProperties().validate();
    }
}

