/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerinstance.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.containerinstance.models.Container;
import com.azure.resourcemanager.containerinstance.models.ContainerGroupDiagnostics;
import com.azure.resourcemanager.containerinstance.models.ContainerGroupPropertiesInstanceView;
import com.azure.resourcemanager.containerinstance.models.ContainerGroupRestartPolicy;
import com.azure.resourcemanager.containerinstance.models.ContainerGroupSku;
import com.azure.resourcemanager.containerinstance.models.ContainerGroupSubnetId;
import com.azure.resourcemanager.containerinstance.models.DnsConfiguration;
import com.azure.resourcemanager.containerinstance.models.EncryptionProperties;
import com.azure.resourcemanager.containerinstance.models.ImageRegistryCredential;
import com.azure.resourcemanager.containerinstance.models.InitContainerDefinition;
import com.azure.resourcemanager.containerinstance.models.IpAddress;
import com.azure.resourcemanager.containerinstance.models.OperatingSystemTypes;
import com.azure.resourcemanager.containerinstance.models.Volume;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class ContainerGroupProperties {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(ContainerGroupProperties.class);
    @JsonProperty(value="provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private String provisioningState;
    @JsonProperty(value="containers", required=true)
    private List<Container> containers;
    @JsonProperty(value="imageRegistryCredentials")
    private List<ImageRegistryCredential> imageRegistryCredentials;
    @JsonProperty(value="restartPolicy")
    private ContainerGroupRestartPolicy restartPolicy;
    @JsonProperty(value="ipAddress")
    private IpAddress ipAddress;
    @JsonProperty(value="osType", required=true)
    private OperatingSystemTypes osType;
    @JsonProperty(value="volumes")
    private List<Volume> volumes;
    @JsonProperty(value="instanceView", access=JsonProperty.Access.WRITE_ONLY)
    private ContainerGroupPropertiesInstanceView instanceView;
    @JsonProperty(value="diagnostics")
    private ContainerGroupDiagnostics diagnostics;
    @JsonProperty(value="subnetIds")
    private List<ContainerGroupSubnetId> subnetIds;
    @JsonProperty(value="dnsConfig")
    private DnsConfiguration dnsConfig;
    @JsonProperty(value="sku")
    private ContainerGroupSku sku;
    @JsonProperty(value="encryptionProperties")
    private EncryptionProperties encryptionProperties;
    @JsonProperty(value="initContainers")
    private List<InitContainerDefinition> initContainers;

    public String provisioningState() {
        return this.provisioningState;
    }

    public List<Container> containers() {
        return this.containers;
    }

    public ContainerGroupProperties withContainers(List<Container> containers) {
        this.containers = containers;
        return this;
    }

    public List<ImageRegistryCredential> imageRegistryCredentials() {
        return this.imageRegistryCredentials;
    }

    public ContainerGroupProperties withImageRegistryCredentials(List<ImageRegistryCredential> imageRegistryCredentials) {
        this.imageRegistryCredentials = imageRegistryCredentials;
        return this;
    }

    public ContainerGroupRestartPolicy restartPolicy() {
        return this.restartPolicy;
    }

    public ContainerGroupProperties withRestartPolicy(ContainerGroupRestartPolicy restartPolicy) {
        this.restartPolicy = restartPolicy;
        return this;
    }

    public IpAddress ipAddress() {
        return this.ipAddress;
    }

    public ContainerGroupProperties withIpAddress(IpAddress ipAddress) {
        this.ipAddress = ipAddress;
        return this;
    }

    public OperatingSystemTypes osType() {
        return this.osType;
    }

    public ContainerGroupProperties withOsType(OperatingSystemTypes osType) {
        this.osType = osType;
        return this;
    }

    public List<Volume> volumes() {
        return this.volumes;
    }

    public ContainerGroupProperties withVolumes(List<Volume> volumes) {
        this.volumes = volumes;
        return this;
    }

    public ContainerGroupPropertiesInstanceView instanceView() {
        return this.instanceView;
    }

    public ContainerGroupDiagnostics diagnostics() {
        return this.diagnostics;
    }

    public ContainerGroupProperties withDiagnostics(ContainerGroupDiagnostics diagnostics) {
        this.diagnostics = diagnostics;
        return this;
    }

    public List<ContainerGroupSubnetId> subnetIds() {
        return this.subnetIds;
    }

    public ContainerGroupProperties withSubnetIds(List<ContainerGroupSubnetId> subnetIds) {
        this.subnetIds = subnetIds;
        return this;
    }

    public DnsConfiguration dnsConfig() {
        return this.dnsConfig;
    }

    public ContainerGroupProperties withDnsConfig(DnsConfiguration dnsConfig) {
        this.dnsConfig = dnsConfig;
        return this;
    }

    public ContainerGroupSku sku() {
        return this.sku;
    }

    public ContainerGroupProperties withSku(ContainerGroupSku sku) {
        this.sku = sku;
        return this;
    }

    public EncryptionProperties encryptionProperties() {
        return this.encryptionProperties;
    }

    public ContainerGroupProperties withEncryptionProperties(EncryptionProperties encryptionProperties) {
        this.encryptionProperties = encryptionProperties;
        return this;
    }

    public List<InitContainerDefinition> initContainers() {
        return this.initContainers;
    }

    public ContainerGroupProperties withInitContainers(List<InitContainerDefinition> initContainers) {
        this.initContainers = initContainers;
        return this;
    }

    public void validate() {
        if (this.containers() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property containers in model ContainerGroupProperties"));
        }
        this.containers().forEach(e -> e.validate());
        if (this.imageRegistryCredentials() != null) {
            this.imageRegistryCredentials().forEach(e -> e.validate());
        }
        if (this.ipAddress() != null) {
            this.ipAddress().validate();
        }
        if (this.osType() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property osType in model ContainerGroupProperties"));
        }
        if (this.volumes() != null) {
            this.volumes().forEach(e -> e.validate());
        }
        if (this.instanceView() != null) {
            this.instanceView().validate();
        }
        if (this.diagnostics() != null) {
            this.diagnostics().validate();
        }
        if (this.subnetIds() != null) {
            this.subnetIds().forEach(e -> e.validate());
        }
        if (this.dnsConfig() != null) {
            this.dnsConfig().validate();
        }
        if (this.encryptionProperties() != null) {
            this.encryptionProperties().validate();
        }
        if (this.initContainers() != null) {
            this.initContainers().forEach(e -> e.validate());
        }
    }
}

