// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerinstance.models;

import com.azure.core.annotation.Immutable;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

/** The regional capabilities. */
@Immutable
public final class Capabilities {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(Capabilities.class);

    /*
     * The resource type that this capability describes.
     */
    @JsonProperty(value = "resourceType", access = JsonProperty.Access.WRITE_ONLY)
    private String resourceType;

    /*
     * The OS type that this capability describes.
     */
    @JsonProperty(value = "osType", access = JsonProperty.Access.WRITE_ONLY)
    private String osType;

    /*
     * The resource location.
     */
    @JsonProperty(value = "location", access = JsonProperty.Access.WRITE_ONLY)
    private String location;

    /*
     * The ip address type that this capability describes.
     */
    @JsonProperty(value = "ipAddressType", access = JsonProperty.Access.WRITE_ONLY)
    private String ipAddressType;

    /*
     * The GPU sku that this capability describes.
     */
    @JsonProperty(value = "gpu", access = JsonProperty.Access.WRITE_ONLY)
    private String gpu;

    /*
     * The supported capabilities.
     */
    @JsonProperty(value = "capabilities", access = JsonProperty.Access.WRITE_ONLY)
    private CapabilitiesCapabilities capabilities;

    /**
     * Get the resourceType property: The resource type that this capability describes.
     *
     * @return the resourceType value.
     */
    public String resourceType() {
        return this.resourceType;
    }

    /**
     * Get the osType property: The OS type that this capability describes.
     *
     * @return the osType value.
     */
    public String osType() {
        return this.osType;
    }

    /**
     * Get the location property: The resource location.
     *
     * @return the location value.
     */
    public String location() {
        return this.location;
    }

    /**
     * Get the ipAddressType property: The ip address type that this capability describes.
     *
     * @return the ipAddressType value.
     */
    public String ipAddressType() {
        return this.ipAddressType;
    }

    /**
     * Get the gpu property: The GPU sku that this capability describes.
     *
     * @return the gpu value.
     */
    public String gpu() {
        return this.gpu;
    }

    /**
     * Get the capabilities property: The supported capabilities.
     *
     * @return the capabilities value.
     */
    public CapabilitiesCapabilities capabilities() {
        return this.capabilities;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (capabilities() != null) {
            capabilities().validate();
        }
    }
}
