// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerinstance.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/** Defines values for GpuSku. */
public final class GpuSku extends ExpandableStringEnum<GpuSku> {
    /** Static value K80 for GpuSku. */
    public static final GpuSku K80 = fromString("K80");

    /** Static value P100 for GpuSku. */
    public static final GpuSku P100 = fromString("P100");

    /** Static value V100 for GpuSku. */
    public static final GpuSku V100 = fromString("V100");

    /**
     * Creates or finds a GpuSku from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding GpuSku.
     */
    @JsonCreator
    public static GpuSku fromString(String name) {
        return fromString(name, GpuSku.class);
    }

    /** @return known GpuSku values. */
    public static Collection<GpuSku> values() {
        return values(GpuSku.class);
    }
}
