// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerinstance.fluent.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/** The information for the container exec command. */
@Fluent
public final class ContainerExecResponseInner {
    /*
     * The uri for the exec websocket.
     */
    @JsonProperty(value = "webSocketUri")
    private String webSocketUri;

    /*
     * The password to start the exec command.
     */
    @JsonProperty(value = "password")
    private String password;

    /**
     * Get the webSocketUri property: The uri for the exec websocket.
     *
     * @return the webSocketUri value.
     */
    public String webSocketUri() {
        return this.webSocketUri;
    }

    /**
     * Set the webSocketUri property: The uri for the exec websocket.
     *
     * @param webSocketUri the webSocketUri value to set.
     * @return the ContainerExecResponseInner object itself.
     */
    public ContainerExecResponseInner withWebSocketUri(String webSocketUri) {
        this.webSocketUri = webSocketUri;
        return this;
    }

    /**
     * Get the password property: The password to start the exec command.
     *
     * @return the password value.
     */
    public String password() {
        return this.password;
    }

    /**
     * Set the password property: The password to start the exec command.
     *
     * @param password the password value to set.
     * @return the ContainerExecResponseInner object itself.
     */
    public ContainerExecResponseInner withPassword(String password) {
        this.password = password;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
