// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerinstance.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.resourcemanager.containerinstance.fluent.ContainersClient;
import com.azure.resourcemanager.containerinstance.fluent.models.ContainerAttachResponseInner;
import com.azure.resourcemanager.containerinstance.fluent.models.ContainerExecResponseInner;
import com.azure.resourcemanager.containerinstance.fluent.models.LogsInner;
import com.azure.resourcemanager.containerinstance.models.ContainerExecRequest;
import reactor.core.publisher.Mono;

/** An instance of this class provides access to all the operations defined in ContainersClient. */
public final class ContainersClientImpl implements ContainersClient {
    /** The proxy service used to perform REST calls. */
    private final ContainersService service;

    /** The service client containing this operation class. */
    private final ContainerInstanceManagementClientImpl client;

    /**
     * Initializes an instance of ContainersClientImpl.
     *
     * @param client the instance of the service client containing this operation class.
     */
    ContainersClientImpl(ContainerInstanceManagementClientImpl client) {
        this.service =
            RestProxy.create(ContainersService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for ContainerInstanceManagementClientContainers to be used by the proxy
     * service to perform REST calls.
     */
    @Host("{$host}")
    @ServiceInterface(name = "ContainerInstanceMan")
    private interface ContainersService {
        @Headers({"Content-Type: application/json"})
        @Get(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerInstance"
                + "/containerGroups/{containerGroupName}/containers/{containerName}/logs")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<LogsInner>> listLogs(
            @HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("containerGroupName") String containerGroupName,
            @PathParam("containerName") String containerName,
            @QueryParam("tail") Integer tail,
            @QueryParam("timestamps") Boolean timestamps,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Post(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerInstance"
                + "/containerGroups/{containerGroupName}/containers/{containerName}/exec")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<ContainerExecResponseInner>> executeCommand(
            @HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("containerGroupName") String containerGroupName,
            @PathParam("containerName") String containerName,
            @BodyParam("application/json") ContainerExecRequest containerExecRequest,
            @HeaderParam("Accept") String accept,
            Context context);

        @Headers({"Content-Type: application/json"})
        @Post(
            "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerInstance"
                + "/containerGroups/{containerGroupName}/containers/{containerName}/attach")
        @ExpectedResponses({200})
        @UnexpectedResponseExceptionType(ManagementException.class)
        Mono<Response<ContainerAttachResponseInner>> attach(
            @HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @QueryParam("api-version") String apiVersion,
            @PathParam("resourceGroupName") String resourceGroupName,
            @PathParam("containerGroupName") String containerGroupName,
            @PathParam("containerName") String containerName,
            @HeaderParam("Accept") String accept,
            Context context);
    }

    /**
     * Get the logs for a specified container instance in a specified resource group and container group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param containerGroupName The name of the container group.
     * @param containerName The name of the container instance.
     * @param tail The number of lines to show from the tail of the container instance log. If not provided, all
     *     available logs are shown up to 4mb.
     * @param timestamps If true, adds a timestamp at the beginning of every line of log output. If not provided,
     *     defaults to false.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the logs for a specified container instance in a specified resource group and container group along with
     *     {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<LogsInner>> listLogsWithResponseAsync(
        String resourceGroupName, String containerGroupName, String containerName, Integer tail, Boolean timestamps) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (containerGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter containerGroupName is required and cannot be null."));
        }
        if (containerName == null) {
            return Mono.error(new IllegalArgumentException("Parameter containerName is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .listLogs(
                            this.client.getEndpoint(),
                            this.client.getSubscriptionId(),
                            this.client.getApiVersion(),
                            resourceGroupName,
                            containerGroupName,
                            containerName,
                            tail,
                            timestamps,
                            accept,
                            context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the logs for a specified container instance in a specified resource group and container group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param containerGroupName The name of the container group.
     * @param containerName The name of the container instance.
     * @param tail The number of lines to show from the tail of the container instance log. If not provided, all
     *     available logs are shown up to 4mb.
     * @param timestamps If true, adds a timestamp at the beginning of every line of log output. If not provided,
     *     defaults to false.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the logs for a specified container instance in a specified resource group and container group along with
     *     {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<LogsInner>> listLogsWithResponseAsync(
        String resourceGroupName,
        String containerGroupName,
        String containerName,
        Integer tail,
        Boolean timestamps,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (containerGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter containerGroupName is required and cannot be null."));
        }
        if (containerName == null) {
            return Mono.error(new IllegalArgumentException("Parameter containerName is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listLogs(
                this.client.getEndpoint(),
                this.client.getSubscriptionId(),
                this.client.getApiVersion(),
                resourceGroupName,
                containerGroupName,
                containerName,
                tail,
                timestamps,
                accept,
                context);
    }

    /**
     * Get the logs for a specified container instance in a specified resource group and container group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param containerGroupName The name of the container group.
     * @param containerName The name of the container instance.
     * @param tail The number of lines to show from the tail of the container instance log. If not provided, all
     *     available logs are shown up to 4mb.
     * @param timestamps If true, adds a timestamp at the beginning of every line of log output. If not provided,
     *     defaults to false.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the logs for a specified container instance in a specified resource group and container group on
     *     successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<LogsInner> listLogsAsync(
        String resourceGroupName, String containerGroupName, String containerName, Integer tail, Boolean timestamps) {
        return listLogsWithResponseAsync(resourceGroupName, containerGroupName, containerName, tail, timestamps)
            .flatMap(
                (Response<LogsInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Get the logs for a specified container instance in a specified resource group and container group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param containerGroupName The name of the container group.
     * @param containerName The name of the container instance.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the logs for a specified container instance in a specified resource group and container group on
     *     successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<LogsInner> listLogsAsync(String resourceGroupName, String containerGroupName, String containerName) {
        final Integer tail = null;
        final Boolean timestamps = null;
        return listLogsWithResponseAsync(resourceGroupName, containerGroupName, containerName, tail, timestamps)
            .flatMap(
                (Response<LogsInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Get the logs for a specified container instance in a specified resource group and container group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param containerGroupName The name of the container group.
     * @param containerName The name of the container instance.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the logs for a specified container instance in a specified resource group and container group.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public LogsInner listLogs(String resourceGroupName, String containerGroupName, String containerName) {
        final Integer tail = null;
        final Boolean timestamps = null;
        return listLogsAsync(resourceGroupName, containerGroupName, containerName, tail, timestamps).block();
    }

    /**
     * Get the logs for a specified container instance in a specified resource group and container group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param containerGroupName The name of the container group.
     * @param containerName The name of the container instance.
     * @param tail The number of lines to show from the tail of the container instance log. If not provided, all
     *     available logs are shown up to 4mb.
     * @param timestamps If true, adds a timestamp at the beginning of every line of log output. If not provided,
     *     defaults to false.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the logs for a specified container instance in a specified resource group and container group along with
     *     {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<LogsInner> listLogsWithResponse(
        String resourceGroupName,
        String containerGroupName,
        String containerName,
        Integer tail,
        Boolean timestamps,
        Context context) {
        return listLogsWithResponseAsync(
                resourceGroupName, containerGroupName, containerName, tail, timestamps, context)
            .block();
    }

    /**
     * Executes a command for a specific container instance in a specified resource group and container group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param containerGroupName The name of the container group.
     * @param containerName The name of the container instance.
     * @param containerExecRequest The request for the exec command.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the information for the container exec command along with {@link Response} on successful completion of
     *     {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<ContainerExecResponseInner>> executeCommandWithResponseAsync(
        String resourceGroupName,
        String containerGroupName,
        String containerName,
        ContainerExecRequest containerExecRequest) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (containerGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter containerGroupName is required and cannot be null."));
        }
        if (containerName == null) {
            return Mono.error(new IllegalArgumentException("Parameter containerName is required and cannot be null."));
        }
        if (containerExecRequest == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter containerExecRequest is required and cannot be null."));
        } else {
            containerExecRequest.validate();
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .executeCommand(
                            this.client.getEndpoint(),
                            this.client.getSubscriptionId(),
                            this.client.getApiVersion(),
                            resourceGroupName,
                            containerGroupName,
                            containerName,
                            containerExecRequest,
                            accept,
                            context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Executes a command for a specific container instance in a specified resource group and container group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param containerGroupName The name of the container group.
     * @param containerName The name of the container instance.
     * @param containerExecRequest The request for the exec command.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the information for the container exec command along with {@link Response} on successful completion of
     *     {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<ContainerExecResponseInner>> executeCommandWithResponseAsync(
        String resourceGroupName,
        String containerGroupName,
        String containerName,
        ContainerExecRequest containerExecRequest,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (containerGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter containerGroupName is required and cannot be null."));
        }
        if (containerName == null) {
            return Mono.error(new IllegalArgumentException("Parameter containerName is required and cannot be null."));
        }
        if (containerExecRequest == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter containerExecRequest is required and cannot be null."));
        } else {
            containerExecRequest.validate();
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .executeCommand(
                this.client.getEndpoint(),
                this.client.getSubscriptionId(),
                this.client.getApiVersion(),
                resourceGroupName,
                containerGroupName,
                containerName,
                containerExecRequest,
                accept,
                context);
    }

    /**
     * Executes a command for a specific container instance in a specified resource group and container group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param containerGroupName The name of the container group.
     * @param containerName The name of the container instance.
     * @param containerExecRequest The request for the exec command.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the information for the container exec command on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ContainerExecResponseInner> executeCommandAsync(
        String resourceGroupName,
        String containerGroupName,
        String containerName,
        ContainerExecRequest containerExecRequest) {
        return executeCommandWithResponseAsync(
                resourceGroupName, containerGroupName, containerName, containerExecRequest)
            .flatMap(
                (Response<ContainerExecResponseInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Executes a command for a specific container instance in a specified resource group and container group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param containerGroupName The name of the container group.
     * @param containerName The name of the container instance.
     * @param containerExecRequest The request for the exec command.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the information for the container exec command.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ContainerExecResponseInner executeCommand(
        String resourceGroupName,
        String containerGroupName,
        String containerName,
        ContainerExecRequest containerExecRequest) {
        return executeCommandAsync(resourceGroupName, containerGroupName, containerName, containerExecRequest).block();
    }

    /**
     * Executes a command for a specific container instance in a specified resource group and container group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param containerGroupName The name of the container group.
     * @param containerName The name of the container instance.
     * @param containerExecRequest The request for the exec command.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the information for the container exec command along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<ContainerExecResponseInner> executeCommandWithResponse(
        String resourceGroupName,
        String containerGroupName,
        String containerName,
        ContainerExecRequest containerExecRequest,
        Context context) {
        return executeCommandWithResponseAsync(
                resourceGroupName, containerGroupName, containerName, containerExecRequest, context)
            .block();
    }

    /**
     * Attach to the output stream of a specific container instance in a specified resource group and container group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param containerGroupName The name of the container group.
     * @param containerName The name of the container instance.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the information for the output stream from container attach along with {@link Response} on successful
     *     completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<ContainerAttachResponseInner>> attachWithResponseAsync(
        String resourceGroupName, String containerGroupName, String containerName) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (containerGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter containerGroupName is required and cannot be null."));
        }
        if (containerName == null) {
            return Mono.error(new IllegalArgumentException("Parameter containerName is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(
                context ->
                    service
                        .attach(
                            this.client.getEndpoint(),
                            this.client.getSubscriptionId(),
                            this.client.getApiVersion(),
                            resourceGroupName,
                            containerGroupName,
                            containerName,
                            accept,
                            context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Attach to the output stream of a specific container instance in a specified resource group and container group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param containerGroupName The name of the container group.
     * @param containerName The name of the container instance.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the information for the output stream from container attach along with {@link Response} on successful
     *     completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<ContainerAttachResponseInner>> attachWithResponseAsync(
        String resourceGroupName, String containerGroupName, String containerName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono
                .error(
                    new IllegalArgumentException(
                        "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (containerGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter containerGroupName is required and cannot be null."));
        }
        if (containerName == null) {
            return Mono.error(new IllegalArgumentException("Parameter containerName is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .attach(
                this.client.getEndpoint(),
                this.client.getSubscriptionId(),
                this.client.getApiVersion(),
                resourceGroupName,
                containerGroupName,
                containerName,
                accept,
                context);
    }

    /**
     * Attach to the output stream of a specific container instance in a specified resource group and container group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param containerGroupName The name of the container group.
     * @param containerName The name of the container instance.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the information for the output stream from container attach on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<ContainerAttachResponseInner> attachAsync(
        String resourceGroupName, String containerGroupName, String containerName) {
        return attachWithResponseAsync(resourceGroupName, containerGroupName, containerName)
            .flatMap(
                (Response<ContainerAttachResponseInner> res) -> {
                    if (res.getValue() != null) {
                        return Mono.just(res.getValue());
                    } else {
                        return Mono.empty();
                    }
                });
    }

    /**
     * Attach to the output stream of a specific container instance in a specified resource group and container group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param containerGroupName The name of the container group.
     * @param containerName The name of the container instance.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the information for the output stream from container attach.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public ContainerAttachResponseInner attach(
        String resourceGroupName, String containerGroupName, String containerName) {
        return attachAsync(resourceGroupName, containerGroupName, containerName).block();
    }

    /**
     * Attach to the output stream of a specific container instance in a specified resource group and container group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param containerGroupName The name of the container group.
     * @param containerName The name of the container instance.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the information for the output stream from container attach along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<ContainerAttachResponseInner> attachWithResponse(
        String resourceGroupName, String containerGroupName, String containerName, Context context) {
        return attachWithResponseAsync(resourceGroupName, containerGroupName, containerName, context).block();
    }
}
