// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerinstance.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/** Defines values for OperatingSystemTypes. */
public final class OperatingSystemTypes extends ExpandableStringEnum<OperatingSystemTypes> {
    /** Static value Windows for OperatingSystemTypes. */
    public static final OperatingSystemTypes WINDOWS = fromString("Windows");

    /** Static value Linux for OperatingSystemTypes. */
    public static final OperatingSystemTypes LINUX = fromString("Linux");

    /**
     * Creates or finds a OperatingSystemTypes from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding OperatingSystemTypes.
     */
    @JsonCreator
    public static OperatingSystemTypes fromString(String name) {
        return fromString(name, OperatingSystemTypes.class);
    }

    /** @return known OperatingSystemTypes values. */
    public static Collection<OperatingSystemTypes> values() {
        return values(OperatingSystemTypes.class);
    }
}
