// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerinstance.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/** The properties for confidential container group. */
@Fluent
public final class ConfidentialComputeProperties {
    /*
     * The base64 encoded confidential compute enforcement policy
     */
    @JsonProperty(value = "ccePolicy")
    private String ccePolicy;

    /** Creates an instance of ConfidentialComputeProperties class. */
    public ConfidentialComputeProperties() {
    }

    /**
     * Get the ccePolicy property: The base64 encoded confidential compute enforcement policy.
     *
     * @return the ccePolicy value.
     */
    public String ccePolicy() {
        return this.ccePolicy;
    }

    /**
     * Set the ccePolicy property: The base64 encoded confidential compute enforcement policy.
     *
     * @param ccePolicy the ccePolicy value to set.
     * @return the ConfidentialComputeProperties object itself.
     */
    public ConfidentialComputeProperties withCcePolicy(String ccePolicy) {
        this.ccePolicy = ccePolicy;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
