// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerinstance.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.containerinstance.models.EnvironmentVariable;
import com.azure.resourcemanager.containerinstance.models.InitContainerPropertiesDefinitionInstanceView;
import com.azure.resourcemanager.containerinstance.models.SecurityContextDefinition;
import com.azure.resourcemanager.containerinstance.models.VolumeMount;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** The init container definition properties. */
@Fluent
public final class InitContainerPropertiesDefinition {
    /*
     * The image of the init container.
     */
    @JsonProperty(value = "image")
    private String image;

    /*
     * The command to execute within the init container in exec form.
     */
    @JsonProperty(value = "command")
    private List<String> command;

    /*
     * The environment variables to set in the init container.
     */
    @JsonProperty(value = "environmentVariables")
    private List<EnvironmentVariable> environmentVariables;

    /*
     * The instance view of the init container. Only valid in response.
     */
    @JsonProperty(value = "instanceView", access = JsonProperty.Access.WRITE_ONLY)
    private InitContainerPropertiesDefinitionInstanceView instanceView;

    /*
     * The volume mounts available to the init container.
     */
    @JsonProperty(value = "volumeMounts")
    private List<VolumeMount> volumeMounts;

    /*
     * The container security properties.
     */
    @JsonProperty(value = "securityContext")
    private SecurityContextDefinition securityContext;

    /** Creates an instance of InitContainerPropertiesDefinition class. */
    public InitContainerPropertiesDefinition() {
    }

    /**
     * Get the image property: The image of the init container.
     *
     * @return the image value.
     */
    public String image() {
        return this.image;
    }

    /**
     * Set the image property: The image of the init container.
     *
     * @param image the image value to set.
     * @return the InitContainerPropertiesDefinition object itself.
     */
    public InitContainerPropertiesDefinition withImage(String image) {
        this.image = image;
        return this;
    }

    /**
     * Get the command property: The command to execute within the init container in exec form.
     *
     * @return the command value.
     */
    public List<String> command() {
        return this.command;
    }

    /**
     * Set the command property: The command to execute within the init container in exec form.
     *
     * @param command the command value to set.
     * @return the InitContainerPropertiesDefinition object itself.
     */
    public InitContainerPropertiesDefinition withCommand(List<String> command) {
        this.command = command;
        return this;
    }

    /**
     * Get the environmentVariables property: The environment variables to set in the init container.
     *
     * @return the environmentVariables value.
     */
    public List<EnvironmentVariable> environmentVariables() {
        return this.environmentVariables;
    }

    /**
     * Set the environmentVariables property: The environment variables to set in the init container.
     *
     * @param environmentVariables the environmentVariables value to set.
     * @return the InitContainerPropertiesDefinition object itself.
     */
    public InitContainerPropertiesDefinition withEnvironmentVariables(List<EnvironmentVariable> environmentVariables) {
        this.environmentVariables = environmentVariables;
        return this;
    }

    /**
     * Get the instanceView property: The instance view of the init container. Only valid in response.
     *
     * @return the instanceView value.
     */
    public InitContainerPropertiesDefinitionInstanceView instanceView() {
        return this.instanceView;
    }

    /**
     * Get the volumeMounts property: The volume mounts available to the init container.
     *
     * @return the volumeMounts value.
     */
    public List<VolumeMount> volumeMounts() {
        return this.volumeMounts;
    }

    /**
     * Set the volumeMounts property: The volume mounts available to the init container.
     *
     * @param volumeMounts the volumeMounts value to set.
     * @return the InitContainerPropertiesDefinition object itself.
     */
    public InitContainerPropertiesDefinition withVolumeMounts(List<VolumeMount> volumeMounts) {
        this.volumeMounts = volumeMounts;
        return this;
    }

    /**
     * Get the securityContext property: The container security properties.
     *
     * @return the securityContext value.
     */
    public SecurityContextDefinition securityContext() {
        return this.securityContext;
    }

    /**
     * Set the securityContext property: The container security properties.
     *
     * @param securityContext the securityContext value to set.
     * @return the InitContainerPropertiesDefinition object itself.
     */
    public InitContainerPropertiesDefinition withSecurityContext(SecurityContextDefinition securityContext) {
        this.securityContext = securityContext;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (environmentVariables() != null) {
            environmentVariables().forEach(e -> e.validate());
        }
        if (instanceView() != null) {
            instanceView().validate();
        }
        if (volumeMounts() != null) {
            volumeMounts().forEach(e -> e.validate());
        }
        if (securityContext() != null) {
            securityContext().validate();
        }
    }
}
