// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerinstance.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/** The security context for the container. */
@Fluent
public final class SecurityContextDefinition {
    /*
     * The flag to determine if the container permissions is elevated to Privileged.
     */
    @JsonProperty(value = "privileged")
    private Boolean privileged;

    /*
     * A boolean value indicating whether the init process can elevate its privileges
     */
    @JsonProperty(value = "allowPrivilegeEscalation")
    private Boolean allowPrivilegeEscalation;

    /*
     * The capabilities to add or drop from a container.
     */
    @JsonProperty(value = "capabilities")
    private SecurityContextCapabilitiesDefinition capabilities;

    /*
     * Sets the User GID for the container.
     */
    @JsonProperty(value = "runAsGroup")
    private Integer runAsGroup;

    /*
     * Sets the User UID for the container.
     */
    @JsonProperty(value = "runAsUser")
    private Integer runAsUser;

    /*
     * a base64 encoded string containing the contents of the JSON in the seccomp profile
     */
    @JsonProperty(value = "seccompProfile")
    private String seccompProfile;

    /** Creates an instance of SecurityContextDefinition class. */
    public SecurityContextDefinition() {
    }

    /**
     * Get the privileged property: The flag to determine if the container permissions is elevated to Privileged.
     *
     * @return the privileged value.
     */
    public Boolean privileged() {
        return this.privileged;
    }

    /**
     * Set the privileged property: The flag to determine if the container permissions is elevated to Privileged.
     *
     * @param privileged the privileged value to set.
     * @return the SecurityContextDefinition object itself.
     */
    public SecurityContextDefinition withPrivileged(Boolean privileged) {
        this.privileged = privileged;
        return this;
    }

    /**
     * Get the allowPrivilegeEscalation property: A boolean value indicating whether the init process can elevate its
     * privileges.
     *
     * @return the allowPrivilegeEscalation value.
     */
    public Boolean allowPrivilegeEscalation() {
        return this.allowPrivilegeEscalation;
    }

    /**
     * Set the allowPrivilegeEscalation property: A boolean value indicating whether the init process can elevate its
     * privileges.
     *
     * @param allowPrivilegeEscalation the allowPrivilegeEscalation value to set.
     * @return the SecurityContextDefinition object itself.
     */
    public SecurityContextDefinition withAllowPrivilegeEscalation(Boolean allowPrivilegeEscalation) {
        this.allowPrivilegeEscalation = allowPrivilegeEscalation;
        return this;
    }

    /**
     * Get the capabilities property: The capabilities to add or drop from a container.
     *
     * @return the capabilities value.
     */
    public SecurityContextCapabilitiesDefinition capabilities() {
        return this.capabilities;
    }

    /**
     * Set the capabilities property: The capabilities to add or drop from a container.
     *
     * @param capabilities the capabilities value to set.
     * @return the SecurityContextDefinition object itself.
     */
    public SecurityContextDefinition withCapabilities(SecurityContextCapabilitiesDefinition capabilities) {
        this.capabilities = capabilities;
        return this;
    }

    /**
     * Get the runAsGroup property: Sets the User GID for the container.
     *
     * @return the runAsGroup value.
     */
    public Integer runAsGroup() {
        return this.runAsGroup;
    }

    /**
     * Set the runAsGroup property: Sets the User GID for the container.
     *
     * @param runAsGroup the runAsGroup value to set.
     * @return the SecurityContextDefinition object itself.
     */
    public SecurityContextDefinition withRunAsGroup(Integer runAsGroup) {
        this.runAsGroup = runAsGroup;
        return this;
    }

    /**
     * Get the runAsUser property: Sets the User UID for the container.
     *
     * @return the runAsUser value.
     */
    public Integer runAsUser() {
        return this.runAsUser;
    }

    /**
     * Set the runAsUser property: Sets the User UID for the container.
     *
     * @param runAsUser the runAsUser value to set.
     * @return the SecurityContextDefinition object itself.
     */
    public SecurityContextDefinition withRunAsUser(Integer runAsUser) {
        this.runAsUser = runAsUser;
        return this;
    }

    /**
     * Get the seccompProfile property: a base64 encoded string containing the contents of the JSON in the seccomp
     * profile.
     *
     * @return the seccompProfile value.
     */
    public String seccompProfile() {
        return this.seccompProfile;
    }

    /**
     * Set the seccompProfile property: a base64 encoded string containing the contents of the JSON in the seccomp
     * profile.
     *
     * @param seccompProfile the seccompProfile value to set.
     * @return the SecurityContextDefinition object itself.
     */
    public SecurityContextDefinition withSeccompProfile(String seccompProfile) {
        this.seccompProfile = seccompProfile;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (capabilities() != null) {
            capabilities().validate();
        }
    }
}
