// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerinstance.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.containerinstance.fluent.models.InitContainerPropertiesDefinition;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** The init container definition. */
@Fluent
public final class InitContainerDefinition {
    /*
     * The name for the init container.
     */
    @JsonProperty(value = "name", required = true)
    private String name;

    /*
     * The properties for the init container.
     */
    @JsonProperty(value = "properties", required = true)
    private InitContainerPropertiesDefinition innerProperties = new InitContainerPropertiesDefinition();

    /** Creates an instance of InitContainerDefinition class. */
    public InitContainerDefinition() {
    }

    /**
     * Get the name property: The name for the init container.
     *
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: The name for the init container.
     *
     * @param name the name value to set.
     * @return the InitContainerDefinition object itself.
     */
    public InitContainerDefinition withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the innerProperties property: The properties for the init container.
     *
     * @return the innerProperties value.
     */
    private InitContainerPropertiesDefinition innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the image property: The image of the init container.
     *
     * @return the image value.
     */
    public String image() {
        return this.innerProperties() == null ? null : this.innerProperties().image();
    }

    /**
     * Set the image property: The image of the init container.
     *
     * @param image the image value to set.
     * @return the InitContainerDefinition object itself.
     */
    public InitContainerDefinition withImage(String image) {
        if (this.innerProperties() == null) {
            this.innerProperties = new InitContainerPropertiesDefinition();
        }
        this.innerProperties().withImage(image);
        return this;
    }

    /**
     * Get the command property: The command to execute within the init container in exec form.
     *
     * @return the command value.
     */
    public List<String> command() {
        return this.innerProperties() == null ? null : this.innerProperties().command();
    }

    /**
     * Set the command property: The command to execute within the init container in exec form.
     *
     * @param command the command value to set.
     * @return the InitContainerDefinition object itself.
     */
    public InitContainerDefinition withCommand(List<String> command) {
        if (this.innerProperties() == null) {
            this.innerProperties = new InitContainerPropertiesDefinition();
        }
        this.innerProperties().withCommand(command);
        return this;
    }

    /**
     * Get the environmentVariables property: The environment variables to set in the init container.
     *
     * @return the environmentVariables value.
     */
    public List<EnvironmentVariable> environmentVariables() {
        return this.innerProperties() == null ? null : this.innerProperties().environmentVariables();
    }

    /**
     * Set the environmentVariables property: The environment variables to set in the init container.
     *
     * @param environmentVariables the environmentVariables value to set.
     * @return the InitContainerDefinition object itself.
     */
    public InitContainerDefinition withEnvironmentVariables(List<EnvironmentVariable> environmentVariables) {
        if (this.innerProperties() == null) {
            this.innerProperties = new InitContainerPropertiesDefinition();
        }
        this.innerProperties().withEnvironmentVariables(environmentVariables);
        return this;
    }

    /**
     * Get the instanceView property: The instance view of the init container. Only valid in response.
     *
     * @return the instanceView value.
     */
    public InitContainerPropertiesDefinitionInstanceView instanceView() {
        return this.innerProperties() == null ? null : this.innerProperties().instanceView();
    }

    /**
     * Get the volumeMounts property: The volume mounts available to the init container.
     *
     * @return the volumeMounts value.
     */
    public List<VolumeMount> volumeMounts() {
        return this.innerProperties() == null ? null : this.innerProperties().volumeMounts();
    }

    /**
     * Set the volumeMounts property: The volume mounts available to the init container.
     *
     * @param volumeMounts the volumeMounts value to set.
     * @return the InitContainerDefinition object itself.
     */
    public InitContainerDefinition withVolumeMounts(List<VolumeMount> volumeMounts) {
        if (this.innerProperties() == null) {
            this.innerProperties = new InitContainerPropertiesDefinition();
        }
        this.innerProperties().withVolumeMounts(volumeMounts);
        return this;
    }

    /**
     * Get the securityContext property: The container security properties.
     *
     * @return the securityContext value.
     */
    public SecurityContextDefinition securityContext() {
        return this.innerProperties() == null ? null : this.innerProperties().securityContext();
    }

    /**
     * Set the securityContext property: The container security properties.
     *
     * @param securityContext the securityContext value to set.
     * @return the InitContainerDefinition object itself.
     */
    public InitContainerDefinition withSecurityContext(SecurityContextDefinition securityContext) {
        if (this.innerProperties() == null) {
            this.innerProperties = new InitContainerPropertiesDefinition();
        }
        this.innerProperties().withSecurityContext(securityContext);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (name() == null) {
            throw LOGGER
                .logExceptionAsError(
                    new IllegalArgumentException("Missing required property name in model InitContainerDefinition"));
        }
        if (innerProperties() == null) {
            throw LOGGER
                .logExceptionAsError(
                    new IllegalArgumentException(
                        "Missing required property innerProperties in model InitContainerDefinition"));
        } else {
            innerProperties().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(InitContainerDefinition.class);
}
