// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerinstance.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** The capabilities to add or drop from a container. */
@Fluent
public final class SecurityContextCapabilitiesDefinition {
    /*
     * The capabilities to add to the container.
     */
    @JsonProperty(value = "add")
    private List<String> add;

    /*
     * The capabilities to drop from the container.
     */
    @JsonProperty(value = "drop")
    private List<String> drop;

    /** Creates an instance of SecurityContextCapabilitiesDefinition class. */
    public SecurityContextCapabilitiesDefinition() {
    }

    /**
     * Get the add property: The capabilities to add to the container.
     *
     * @return the add value.
     */
    public List<String> add() {
        return this.add;
    }

    /**
     * Set the add property: The capabilities to add to the container.
     *
     * @param add the add value to set.
     * @return the SecurityContextCapabilitiesDefinition object itself.
     */
    public SecurityContextCapabilitiesDefinition withAdd(List<String> add) {
        this.add = add;
        return this;
    }

    /**
     * Get the drop property: The capabilities to drop from the container.
     *
     * @return the drop value.
     */
    public List<String> drop() {
        return this.drop;
    }

    /**
     * Set the drop property: The capabilities to drop from the container.
     *
     * @param drop the drop value to set.
     * @return the SecurityContextCapabilitiesDefinition object itself.
     */
    public SecurityContextCapabilitiesDefinition withDrop(List<String> drop) {
        this.drop = drop;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
