// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerinstance.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The information for the container exec command.
 */
@Fluent
public final class ContainerExecResponseInner implements JsonSerializable<ContainerExecResponseInner> {
    /*
     * The uri for the exec websocket.
     */
    private String webSocketUri;

    /*
     * The password to start the exec command.
     */
    private String password;

    /**
     * Creates an instance of ContainerExecResponseInner class.
     */
    public ContainerExecResponseInner() {
    }

    /**
     * Get the webSocketUri property: The uri for the exec websocket.
     * 
     * @return the webSocketUri value.
     */
    public String webSocketUri() {
        return this.webSocketUri;
    }

    /**
     * Set the webSocketUri property: The uri for the exec websocket.
     * 
     * @param webSocketUri the webSocketUri value to set.
     * @return the ContainerExecResponseInner object itself.
     */
    public ContainerExecResponseInner withWebSocketUri(String webSocketUri) {
        this.webSocketUri = webSocketUri;
        return this;
    }

    /**
     * Get the password property: The password to start the exec command.
     * 
     * @return the password value.
     */
    public String password() {
        return this.password;
    }

    /**
     * Set the password property: The password to start the exec command.
     * 
     * @param password the password value to set.
     * @return the ContainerExecResponseInner object itself.
     */
    public ContainerExecResponseInner withPassword(String password) {
        this.password = password;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("webSocketUri", this.webSocketUri);
        jsonWriter.writeStringField("password", this.password);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ContainerExecResponseInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ContainerExecResponseInner if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ContainerExecResponseInner.
     */
    public static ContainerExecResponseInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ContainerExecResponseInner deserializedContainerExecResponseInner = new ContainerExecResponseInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("webSocketUri".equals(fieldName)) {
                    deserializedContainerExecResponseInner.webSocketUri = reader.getString();
                } else if ("password".equals(fieldName)) {
                    deserializedContainerExecResponseInner.password = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedContainerExecResponseInner;
        });
    }
}
