// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerinstance.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * The response containing cached images.
 */
@Fluent
public final class CachedImagesListResult implements JsonSerializable<CachedImagesListResult> {
    /*
     * The list of cached images.
     */
    private List<CachedImages> value;

    /*
     * The URI to fetch the next page of cached images.
     */
    private String nextLink;

    /**
     * Creates an instance of CachedImagesListResult class.
     */
    public CachedImagesListResult() {
    }

    /**
     * Get the value property: The list of cached images.
     * 
     * @return the value value.
     */
    public List<CachedImages> value() {
        return this.value;
    }

    /**
     * Set the value property: The list of cached images.
     * 
     * @param value the value value to set.
     * @return the CachedImagesListResult object itself.
     */
    public CachedImagesListResult withValue(List<CachedImages> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: The URI to fetch the next page of cached images.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: The URI to fetch the next page of cached images.
     * 
     * @param nextLink the nextLink value to set.
     * @return the CachedImagesListResult object itself.
     */
    public CachedImagesListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of CachedImagesListResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of CachedImagesListResult if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the CachedImagesListResult.
     */
    public static CachedImagesListResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            CachedImagesListResult deserializedCachedImagesListResult = new CachedImagesListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<CachedImages> value = reader.readArray(reader1 -> CachedImages.fromJson(reader1));
                    deserializedCachedImagesListResult.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedCachedImagesListResult.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedCachedImagesListResult;
        });
    }
}
