// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerinstance.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * The operating system type required by the containers in the container group.
 */
public final class OperatingSystemTypes extends ExpandableStringEnum<OperatingSystemTypes> {
    /**
     * Static value Windows for OperatingSystemTypes.
     */
    public static final OperatingSystemTypes WINDOWS = fromString("Windows");

    /**
     * Static value Linux for OperatingSystemTypes.
     */
    public static final OperatingSystemTypes LINUX = fromString("Linux");

    /**
     * Creates a new instance of OperatingSystemTypes value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public OperatingSystemTypes() {
    }

    /**
     * Creates or finds a OperatingSystemTypes from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding OperatingSystemTypes.
     */
    public static OperatingSystemTypes fromString(String name) {
        return fromString(name, OperatingSystemTypes.class);
    }

    /**
     * Gets known OperatingSystemTypes values.
     * 
     * @return known OperatingSystemTypes values.
     */
    public static Collection<OperatingSystemTypes> values() {
        return values(OperatingSystemTypes.class);
    }
}
