// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerinstance.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The information for the output stream from container attach.
 */
@Fluent
public final class ContainerAttachResponseInner implements JsonSerializable<ContainerAttachResponseInner> {
    /*
     * The uri for the output stream from the attach.
     */
    private String webSocketUri;

    /*
     * The password to the output stream from the attach. Send as an Authorization header value when connecting to the
     * websocketUri.
     */
    private String password;

    /**
     * Creates an instance of ContainerAttachResponseInner class.
     */
    public ContainerAttachResponseInner() {
    }

    /**
     * Get the webSocketUri property: The uri for the output stream from the attach.
     * 
     * @return the webSocketUri value.
     */
    public String webSocketUri() {
        return this.webSocketUri;
    }

    /**
     * Set the webSocketUri property: The uri for the output stream from the attach.
     * 
     * @param webSocketUri the webSocketUri value to set.
     * @return the ContainerAttachResponseInner object itself.
     */
    public ContainerAttachResponseInner withWebSocketUri(String webSocketUri) {
        this.webSocketUri = webSocketUri;
        return this;
    }

    /**
     * Get the password property: The password to the output stream from the attach. Send as an Authorization header
     * value when connecting to the websocketUri.
     * 
     * @return the password value.
     */
    public String password() {
        return this.password;
    }

    /**
     * Set the password property: The password to the output stream from the attach. Send as an Authorization header
     * value when connecting to the websocketUri.
     * 
     * @param password the password value to set.
     * @return the ContainerAttachResponseInner object itself.
     */
    public ContainerAttachResponseInner withPassword(String password) {
        this.password = password;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("webSocketUri", this.webSocketUri);
        jsonWriter.writeStringField("password", this.password);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ContainerAttachResponseInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ContainerAttachResponseInner if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ContainerAttachResponseInner.
     */
    public static ContainerAttachResponseInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ContainerAttachResponseInner deserializedContainerAttachResponseInner = new ContainerAttachResponseInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("webSocketUri".equals(fieldName)) {
                    deserializedContainerAttachResponseInner.webSocketUri = reader.getString();
                } else if ("password".equals(fieldName)) {
                    deserializedContainerAttachResponseInner.password = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedContainerAttachResponseInner;
        });
    }
}
