// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerinstance.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Represents a volume that is populated with the contents of a git repository.
 */
@Fluent
public final class GitRepoVolume implements JsonSerializable<GitRepoVolume> {
    /*
     * Target directory name. Must not contain or start with '..'. If '.' is supplied, the volume directory will be the
     * git repository. Otherwise, if specified, the volume will contain the git repository in the subdirectory with the
     * given name.
     */
    private String directory;

    /*
     * Repository URL
     */
    private String repository;

    /*
     * Commit hash for the specified revision.
     */
    private String revision;

    /**
     * Creates an instance of GitRepoVolume class.
     */
    public GitRepoVolume() {
    }

    /**
     * Get the directory property: Target directory name. Must not contain or start with '..'. If '.' is supplied, the
     * volume directory will be the git repository. Otherwise, if specified, the volume will contain the git repository
     * in the subdirectory with the given name.
     * 
     * @return the directory value.
     */
    public String directory() {
        return this.directory;
    }

    /**
     * Set the directory property: Target directory name. Must not contain or start with '..'. If '.' is supplied, the
     * volume directory will be the git repository. Otherwise, if specified, the volume will contain the git repository
     * in the subdirectory with the given name.
     * 
     * @param directory the directory value to set.
     * @return the GitRepoVolume object itself.
     */
    public GitRepoVolume withDirectory(String directory) {
        this.directory = directory;
        return this;
    }

    /**
     * Get the repository property: Repository URL.
     * 
     * @return the repository value.
     */
    public String repository() {
        return this.repository;
    }

    /**
     * Set the repository property: Repository URL.
     * 
     * @param repository the repository value to set.
     * @return the GitRepoVolume object itself.
     */
    public GitRepoVolume withRepository(String repository) {
        this.repository = repository;
        return this;
    }

    /**
     * Get the revision property: Commit hash for the specified revision.
     * 
     * @return the revision value.
     */
    public String revision() {
        return this.revision;
    }

    /**
     * Set the revision property: Commit hash for the specified revision.
     * 
     * @param revision the revision value to set.
     * @return the GitRepoVolume object itself.
     */
    public GitRepoVolume withRevision(String revision) {
        this.revision = revision;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (repository() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property repository in model GitRepoVolume"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(GitRepoVolume.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("repository", this.repository);
        jsonWriter.writeStringField("directory", this.directory);
        jsonWriter.writeStringField("revision", this.revision);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of GitRepoVolume from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of GitRepoVolume if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the GitRepoVolume.
     */
    public static GitRepoVolume fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            GitRepoVolume deserializedGitRepoVolume = new GitRepoVolume();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("repository".equals(fieldName)) {
                    deserializedGitRepoVolume.repository = reader.getString();
                } else if ("directory".equals(fieldName)) {
                    deserializedGitRepoVolume.directory = reader.getString();
                } else if ("revision".equals(fieldName)) {
                    deserializedGitRepoVolume.revision = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedGitRepoVolume;
        });
    }
}
