// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerinstance.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The supported capabilities.
 */
@Immutable
public final class CapabilitiesCapabilities implements JsonSerializable<CapabilitiesCapabilities> {
    /*
     * The maximum allowed memory request in GB.
     */
    private Float maxMemoryInGB;

    /*
     * The maximum allowed CPU request in cores.
     */
    private Float maxCpu;

    /*
     * The maximum allowed GPU count.
     */
    private Float maxGpuCount;

    /**
     * Creates an instance of CapabilitiesCapabilities class.
     */
    public CapabilitiesCapabilities() {
    }

    /**
     * Get the maxMemoryInGB property: The maximum allowed memory request in GB.
     * 
     * @return the maxMemoryInGB value.
     */
    public Float maxMemoryInGB() {
        return this.maxMemoryInGB;
    }

    /**
     * Get the maxCpu property: The maximum allowed CPU request in cores.
     * 
     * @return the maxCpu value.
     */
    public Float maxCpu() {
        return this.maxCpu;
    }

    /**
     * Get the maxGpuCount property: The maximum allowed GPU count.
     * 
     * @return the maxGpuCount value.
     */
    public Float maxGpuCount() {
        return this.maxGpuCount;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of CapabilitiesCapabilities from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of CapabilitiesCapabilities if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the CapabilitiesCapabilities.
     */
    public static CapabilitiesCapabilities fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            CapabilitiesCapabilities deserializedCapabilitiesCapabilities = new CapabilitiesCapabilities();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("maxMemoryInGB".equals(fieldName)) {
                    deserializedCapabilitiesCapabilities.maxMemoryInGB = reader.getNullable(JsonReader::getFloat);
                } else if ("maxCpu".equals(fieldName)) {
                    deserializedCapabilitiesCapabilities.maxCpu = reader.getNullable(JsonReader::getFloat);
                } else if ("maxGpuCount".equals(fieldName)) {
                    deserializedCapabilitiesCapabilities.maxGpuCount = reader.getNullable(JsonReader::getFloat);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedCapabilitiesCapabilities;
        });
    }
}
