// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerinstance.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The resource requests.
 */
@Fluent
public final class ResourceRequests implements JsonSerializable<ResourceRequests> {
    /*
     * The memory request in GB of this container instance.
     */
    private double memoryInGB;

    /*
     * The CPU request of this container instance.
     */
    private double cpu;

    /*
     * The GPU request of this container instance.
     */
    private GpuResource gpu;

    /**
     * Creates an instance of ResourceRequests class.
     */
    public ResourceRequests() {
    }

    /**
     * Get the memoryInGB property: The memory request in GB of this container instance.
     * 
     * @return the memoryInGB value.
     */
    public double memoryInGB() {
        return this.memoryInGB;
    }

    /**
     * Set the memoryInGB property: The memory request in GB of this container instance.
     * 
     * @param memoryInGB the memoryInGB value to set.
     * @return the ResourceRequests object itself.
     */
    public ResourceRequests withMemoryInGB(double memoryInGB) {
        this.memoryInGB = memoryInGB;
        return this;
    }

    /**
     * Get the cpu property: The CPU request of this container instance.
     * 
     * @return the cpu value.
     */
    public double cpu() {
        return this.cpu;
    }

    /**
     * Set the cpu property: The CPU request of this container instance.
     * 
     * @param cpu the cpu value to set.
     * @return the ResourceRequests object itself.
     */
    public ResourceRequests withCpu(double cpu) {
        this.cpu = cpu;
        return this;
    }

    /**
     * Get the gpu property: The GPU request of this container instance.
     * 
     * @return the gpu value.
     */
    public GpuResource gpu() {
        return this.gpu;
    }

    /**
     * Set the gpu property: The GPU request of this container instance.
     * 
     * @param gpu the gpu value to set.
     * @return the ResourceRequests object itself.
     */
    public ResourceRequests withGpu(GpuResource gpu) {
        this.gpu = gpu;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (gpu() != null) {
            gpu().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeDoubleField("memoryInGB", this.memoryInGB);
        jsonWriter.writeDoubleField("cpu", this.cpu);
        jsonWriter.writeJsonField("gpu", this.gpu);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ResourceRequests from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ResourceRequests if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ResourceRequests.
     */
    public static ResourceRequests fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ResourceRequests deserializedResourceRequests = new ResourceRequests();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("memoryInGB".equals(fieldName)) {
                    deserializedResourceRequests.memoryInGB = reader.getDouble();
                } else if ("cpu".equals(fieldName)) {
                    deserializedResourceRequests.cpu = reader.getDouble();
                } else if ("gpu".equals(fieldName)) {
                    deserializedResourceRequests.gpu = GpuResource.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedResourceRequests;
        });
    }
}
