/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerinstance.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerinstance.models.EnvironmentVariable;
import com.azure.resourcemanager.containerinstance.models.InitContainerPropertiesDefinitionInstanceView;
import com.azure.resourcemanager.containerinstance.models.SecurityContextDefinition;
import com.azure.resourcemanager.containerinstance.models.VolumeMount;
import java.io.IOException;
import java.util.List;

public final class InitContainerPropertiesDefinition
implements JsonSerializable<InitContainerPropertiesDefinition> {
    private String image;
    private List<String> command;
    private List<EnvironmentVariable> environmentVariables;
    private InitContainerPropertiesDefinitionInstanceView instanceView;
    private List<VolumeMount> volumeMounts;
    private SecurityContextDefinition securityContext;

    public String image() {
        return this.image;
    }

    public InitContainerPropertiesDefinition withImage(String image) {
        this.image = image;
        return this;
    }

    public List<String> command() {
        return this.command;
    }

    public InitContainerPropertiesDefinition withCommand(List<String> command) {
        this.command = command;
        return this;
    }

    public List<EnvironmentVariable> environmentVariables() {
        return this.environmentVariables;
    }

    public InitContainerPropertiesDefinition withEnvironmentVariables(List<EnvironmentVariable> environmentVariables) {
        this.environmentVariables = environmentVariables;
        return this;
    }

    public InitContainerPropertiesDefinitionInstanceView instanceView() {
        return this.instanceView;
    }

    public List<VolumeMount> volumeMounts() {
        return this.volumeMounts;
    }

    public InitContainerPropertiesDefinition withVolumeMounts(List<VolumeMount> volumeMounts) {
        this.volumeMounts = volumeMounts;
        return this;
    }

    public SecurityContextDefinition securityContext() {
        return this.securityContext;
    }

    public InitContainerPropertiesDefinition withSecurityContext(SecurityContextDefinition securityContext) {
        this.securityContext = securityContext;
        return this;
    }

    public void validate() {
        if (this.environmentVariables() != null) {
            this.environmentVariables().forEach(e -> e.validate());
        }
        if (this.instanceView() != null) {
            this.instanceView().validate();
        }
        if (this.volumeMounts() != null) {
            this.volumeMounts().forEach(e -> e.validate());
        }
        if (this.securityContext() != null) {
            this.securityContext().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("image", this.image);
        jsonWriter.writeArrayField("command", this.command, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("environmentVariables", this.environmentVariables, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("volumeMounts", this.volumeMounts, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("securityContext", (JsonSerializable)this.securityContext);
        return jsonWriter.writeEndObject();
    }

    public static InitContainerPropertiesDefinition fromJson(JsonReader jsonReader) throws IOException {
        return (InitContainerPropertiesDefinition)jsonReader.readObject(reader -> {
            InitContainerPropertiesDefinition deserializedInitContainerPropertiesDefinition = new InitContainerPropertiesDefinition();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("image".equals(fieldName)) {
                    deserializedInitContainerPropertiesDefinition.image = reader.getString();
                    continue;
                }
                if ("command".equals(fieldName)) {
                    List command;
                    deserializedInitContainerPropertiesDefinition.command = command = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("environmentVariables".equals(fieldName)) {
                    List environmentVariables;
                    deserializedInitContainerPropertiesDefinition.environmentVariables = environmentVariables = reader.readArray(reader1 -> EnvironmentVariable.fromJson(reader1));
                    continue;
                }
                if ("instanceView".equals(fieldName)) {
                    deserializedInitContainerPropertiesDefinition.instanceView = InitContainerPropertiesDefinitionInstanceView.fromJson(reader);
                    continue;
                }
                if ("volumeMounts".equals(fieldName)) {
                    List volumeMounts;
                    deserializedInitContainerPropertiesDefinition.volumeMounts = volumeMounts = reader.readArray(reader1 -> VolumeMount.fromJson(reader1));
                    continue;
                }
                if ("securityContext".equals(fieldName)) {
                    deserializedInitContainerPropertiesDefinition.securityContext = SecurityContextDefinition.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedInitContainerPropertiesDefinition;
        });
    }
}

