/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerinstance.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerinstance.models.AzureFileVolume;
import com.azure.resourcemanager.containerinstance.models.GitRepoVolume;
import java.io.IOException;
import java.util.Map;

public final class Volume
implements JsonSerializable<Volume> {
    private String name;
    private AzureFileVolume azureFile;
    private Object emptyDir;
    private Map<String, String> secret;
    private GitRepoVolume gitRepo;
    private static final ClientLogger LOGGER = new ClientLogger(Volume.class);

    public String name() {
        return this.name;
    }

    public Volume withName(String name) {
        this.name = name;
        return this;
    }

    public AzureFileVolume azureFile() {
        return this.azureFile;
    }

    public Volume withAzureFile(AzureFileVolume azureFile) {
        this.azureFile = azureFile;
        return this;
    }

    public Object emptyDir() {
        return this.emptyDir;
    }

    public Volume withEmptyDir(Object emptyDir) {
        this.emptyDir = emptyDir;
        return this;
    }

    public Map<String, String> secret() {
        return this.secret;
    }

    public Volume withSecret(Map<String, String> secret) {
        this.secret = secret;
        return this;
    }

    public GitRepoVolume gitRepo() {
        return this.gitRepo;
    }

    public Volume withGitRepo(GitRepoVolume gitRepo) {
        this.gitRepo = gitRepo;
        return this;
    }

    public void validate() {
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model Volume"));
        }
        if (this.azureFile() != null) {
            this.azureFile().validate();
        }
        if (this.gitRepo() != null) {
            this.gitRepo().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeJsonField("azureFile", (JsonSerializable)this.azureFile);
        jsonWriter.writeUntypedField("emptyDir", this.emptyDir);
        jsonWriter.writeMapField("secret", this.secret, (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("gitRepo", (JsonSerializable)this.gitRepo);
        return jsonWriter.writeEndObject();
    }

    public static Volume fromJson(JsonReader jsonReader) throws IOException {
        return (Volume)jsonReader.readObject(reader -> {
            Volume deserializedVolume = new Volume();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedVolume.name = reader.getString();
                    continue;
                }
                if ("azureFile".equals(fieldName)) {
                    deserializedVolume.azureFile = AzureFileVolume.fromJson(reader);
                    continue;
                }
                if ("emptyDir".equals(fieldName)) {
                    deserializedVolume.emptyDir = reader.readUntyped();
                    continue;
                }
                if ("secret".equals(fieldName)) {
                    Map secret;
                    deserializedVolume.secret = secret = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("gitRepo".equals(fieldName)) {
                    deserializedVolume.gitRepo = GitRepoVolume.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVolume;
        });
    }
}

