// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerinstance.implementation;

import com.azure.core.annotation.ServiceClient;
import com.azure.core.http.HttpPipeline;
import com.azure.core.management.AzureEnvironment;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.containerinstance.fluent.ContainerGroupsClient;
import com.azure.resourcemanager.containerinstance.fluent.ContainerInstanceManagementClient;
import com.azure.resourcemanager.containerinstance.fluent.ContainersClient;
import com.azure.resourcemanager.containerinstance.fluent.LocationsClient;
import com.azure.resourcemanager.containerinstance.fluent.OperationsClient;
import com.azure.resourcemanager.containerinstance.fluent.SubnetServiceAssociationLinksClient;
import com.azure.resourcemanager.resources.fluentcore.AzureServiceClient;
import java.time.Duration;

/**
 * Initializes a new instance of the ContainerInstanceManagementClientImpl type.
 */
@ServiceClient(builder = ContainerInstanceManagementClientBuilder.class)
public final class ContainerInstanceManagementClientImpl extends AzureServiceClient
    implements ContainerInstanceManagementClient {
    /**
     * Subscription credentials which uniquely identify Microsoft Azure subscription. The subscription ID forms part of
     * the URI for every service call.
     */
    private final String subscriptionId;

    /**
     * Gets Subscription credentials which uniquely identify Microsoft Azure subscription. The subscription ID forms
     * part of the URI for every service call.
     * 
     * @return the subscriptionId value.
     */
    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    /**
     * server parameter.
     */
    private final String endpoint;

    /**
     * Gets server parameter.
     * 
     * @return the endpoint value.
     */
    public String getEndpoint() {
        return this.endpoint;
    }

    /**
     * Api Version.
     */
    private final String apiVersion;

    /**
     * Gets Api Version.
     * 
     * @return the apiVersion value.
     */
    public String getApiVersion() {
        return this.apiVersion;
    }

    /**
     * The HTTP pipeline to send requests through.
     */
    private final HttpPipeline httpPipeline;

    /**
     * Gets The HTTP pipeline to send requests through.
     * 
     * @return the httpPipeline value.
     */
    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    /**
     * The serializer to serialize an object into a string.
     */
    private final SerializerAdapter serializerAdapter;

    /**
     * Gets The serializer to serialize an object into a string.
     * 
     * @return the serializerAdapter value.
     */
    SerializerAdapter getSerializerAdapter() {
        return this.serializerAdapter;
    }

    /**
     * The default poll interval for long-running operation.
     */
    private final Duration defaultPollInterval;

    /**
     * Gets The default poll interval for long-running operation.
     * 
     * @return the defaultPollInterval value.
     */
    public Duration getDefaultPollInterval() {
        return this.defaultPollInterval;
    }

    /**
     * The ContainerGroupsClient object to access its operations.
     */
    private final ContainerGroupsClient containerGroups;

    /**
     * Gets the ContainerGroupsClient object to access its operations.
     * 
     * @return the ContainerGroupsClient object.
     */
    public ContainerGroupsClient getContainerGroups() {
        return this.containerGroups;
    }

    /**
     * The OperationsClient object to access its operations.
     */
    private final OperationsClient operations;

    /**
     * Gets the OperationsClient object to access its operations.
     * 
     * @return the OperationsClient object.
     */
    public OperationsClient getOperations() {
        return this.operations;
    }

    /**
     * The LocationsClient object to access its operations.
     */
    private final LocationsClient locations;

    /**
     * Gets the LocationsClient object to access its operations.
     * 
     * @return the LocationsClient object.
     */
    public LocationsClient getLocations() {
        return this.locations;
    }

    /**
     * The ContainersClient object to access its operations.
     */
    private final ContainersClient containers;

    /**
     * Gets the ContainersClient object to access its operations.
     * 
     * @return the ContainersClient object.
     */
    public ContainersClient getContainers() {
        return this.containers;
    }

    /**
     * The SubnetServiceAssociationLinksClient object to access its operations.
     */
    private final SubnetServiceAssociationLinksClient subnetServiceAssociationLinks;

    /**
     * Gets the SubnetServiceAssociationLinksClient object to access its operations.
     * 
     * @return the SubnetServiceAssociationLinksClient object.
     */
    public SubnetServiceAssociationLinksClient getSubnetServiceAssociationLinks() {
        return this.subnetServiceAssociationLinks;
    }

    /**
     * Initializes an instance of ContainerInstanceManagementClient client.
     * 
     * @param httpPipeline The HTTP pipeline to send requests through.
     * @param serializerAdapter The serializer to serialize an object into a string.
     * @param defaultPollInterval The default poll interval for long-running operation.
     * @param environment The Azure environment.
     * @param subscriptionId Subscription credentials which uniquely identify Microsoft Azure subscription. The
     * subscription ID forms part of the URI for every service call.
     * @param endpoint server parameter.
     */
    ContainerInstanceManagementClientImpl(HttpPipeline httpPipeline, SerializerAdapter serializerAdapter,
        Duration defaultPollInterval, AzureEnvironment environment, String subscriptionId, String endpoint) {
        super(httpPipeline, serializerAdapter, environment);
        this.httpPipeline = httpPipeline;
        this.serializerAdapter = serializerAdapter;
        this.defaultPollInterval = defaultPollInterval;
        this.subscriptionId = subscriptionId;
        this.endpoint = endpoint;
        this.apiVersion = "2023-05-01";
        this.containerGroups = new ContainerGroupsClientImpl(this);
        this.operations = new OperationsClientImpl(this);
        this.locations = new LocationsClientImpl(this);
        this.containers = new ContainersClientImpl(this);
        this.subnetServiceAssociationLinks = new SubnetServiceAssociationLinksClientImpl(this);
    }
}
