// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerinstance.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The cached image and OS type.
 */
@Fluent
public final class CachedImages implements JsonSerializable<CachedImages> {
    /*
     * The OS type of the cached image.
     */
    private String osType;

    /*
     * The cached image name.
     */
    private String image;

    /**
     * Creates an instance of CachedImages class.
     */
    public CachedImages() {
    }

    /**
     * Get the osType property: The OS type of the cached image.
     * 
     * @return the osType value.
     */
    public String osType() {
        return this.osType;
    }

    /**
     * Set the osType property: The OS type of the cached image.
     * 
     * @param osType the osType value to set.
     * @return the CachedImages object itself.
     */
    public CachedImages withOsType(String osType) {
        this.osType = osType;
        return this;
    }

    /**
     * Get the image property: The cached image name.
     * 
     * @return the image value.
     */
    public String image() {
        return this.image;
    }

    /**
     * Set the image property: The cached image name.
     * 
     * @param image the image value to set.
     * @return the CachedImages object itself.
     */
    public CachedImages withImage(String image) {
        this.image = image;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (osType() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property osType in model CachedImages"));
        }
        if (image() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property image in model CachedImages"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(CachedImages.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("osType", this.osType);
        jsonWriter.writeStringField("image", this.image);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of CachedImages from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of CachedImages if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the CachedImages.
     */
    public static CachedImages fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            CachedImages deserializedCachedImages = new CachedImages();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("osType".equals(fieldName)) {
                    deserializedCachedImages.osType = reader.getString();
                } else if ("image".equals(fieldName)) {
                    deserializedCachedImages.image = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedCachedImages;
        });
    }
}
