// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerinstance.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Container group subnet information.
 */
@Fluent
public final class ContainerGroupSubnetId implements JsonSerializable<ContainerGroupSubnetId> {
    /*
     * Resource ID of virtual network and subnet.
     */
    private String id;

    /*
     * Friendly name for the subnet.
     */
    private String name;

    /**
     * Creates an instance of ContainerGroupSubnetId class.
     */
    public ContainerGroupSubnetId() {
    }

    /**
     * Get the id property: Resource ID of virtual network and subnet.
     * 
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Set the id property: Resource ID of virtual network and subnet.
     * 
     * @param id the id value to set.
     * @return the ContainerGroupSubnetId object itself.
     */
    public ContainerGroupSubnetId withId(String id) {
        this.id = id;
        return this;
    }

    /**
     * Get the name property: Friendly name for the subnet.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: Friendly name for the subnet.
     * 
     * @param name the name value to set.
     * @return the ContainerGroupSubnetId object itself.
     */
    public ContainerGroupSubnetId withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (id() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property id in model ContainerGroupSubnetId"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(ContainerGroupSubnetId.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("name", this.name);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ContainerGroupSubnetId from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ContainerGroupSubnetId if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ContainerGroupSubnetId.
     */
    public static ContainerGroupSubnetId fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ContainerGroupSubnetId deserializedContainerGroupSubnetId = new ContainerGroupSubnetId();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedContainerGroupSubnetId.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedContainerGroupSubnetId.name = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedContainerGroupSubnetId;
        });
    }
}
