// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerinstance.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The port exposed on the container instance.
 */
@Fluent
public final class ContainerPort implements JsonSerializable<ContainerPort> {
    /*
     * The protocol associated with the port.
     */
    private ContainerNetworkProtocol protocol;

    /*
     * The port number exposed within the container group.
     */
    private int port;

    /**
     * Creates an instance of ContainerPort class.
     */
    public ContainerPort() {
    }

    /**
     * Get the protocol property: The protocol associated with the port.
     * 
     * @return the protocol value.
     */
    public ContainerNetworkProtocol protocol() {
        return this.protocol;
    }

    /**
     * Set the protocol property: The protocol associated with the port.
     * 
     * @param protocol the protocol value to set.
     * @return the ContainerPort object itself.
     */
    public ContainerPort withProtocol(ContainerNetworkProtocol protocol) {
        this.protocol = protocol;
        return this;
    }

    /**
     * Get the port property: The port number exposed within the container group.
     * 
     * @return the port value.
     */
    public int port() {
        return this.port;
    }

    /**
     * Set the port property: The port number exposed within the container group.
     * 
     * @param port the port value to set.
     * @return the ContainerPort object itself.
     */
    public ContainerPort withPort(int port) {
        this.port = port;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeIntField("port", this.port);
        jsonWriter.writeStringField("protocol", this.protocol == null ? null : this.protocol.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ContainerPort from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ContainerPort if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ContainerPort.
     */
    public static ContainerPort fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ContainerPort deserializedContainerPort = new ContainerPort();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("port".equals(fieldName)) {
                    deserializedContainerPort.port = reader.getInt();
                } else if ("protocol".equals(fieldName)) {
                    deserializedContainerPort.protocol = ContainerNetworkProtocol.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedContainerPort;
        });
    }
}
