// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerinstance.models;

import com.azure.core.annotation.Immutable;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;

/**
 * A container group or container instance event.
 */
@Immutable
public final class Event implements JsonSerializable<Event> {
    /*
     * The count of the event.
     */
    private Integer count;

    /*
     * The date-time of the earliest logged event.
     */
    private OffsetDateTime firstTimestamp;

    /*
     * The date-time of the latest logged event.
     */
    private OffsetDateTime lastTimestamp;

    /*
     * The event name.
     */
    private String name;

    /*
     * The event message.
     */
    private String message;

    /*
     * The event type.
     */
    private String type;

    /**
     * Creates an instance of Event class.
     */
    public Event() {
    }

    /**
     * Get the count property: The count of the event.
     * 
     * @return the count value.
     */
    public Integer count() {
        return this.count;
    }

    /**
     * Get the firstTimestamp property: The date-time of the earliest logged event.
     * 
     * @return the firstTimestamp value.
     */
    public OffsetDateTime firstTimestamp() {
        return this.firstTimestamp;
    }

    /**
     * Get the lastTimestamp property: The date-time of the latest logged event.
     * 
     * @return the lastTimestamp value.
     */
    public OffsetDateTime lastTimestamp() {
        return this.lastTimestamp;
    }

    /**
     * Get the name property: The event name.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Get the message property: The event message.
     * 
     * @return the message value.
     */
    public String message() {
        return this.message;
    }

    /**
     * Get the type property: The event type.
     * 
     * @return the type value.
     */
    public String type() {
        return this.type;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of Event from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of Event if the JsonReader was pointing to an instance of it, or null if it was pointing to
     * JSON null.
     * @throws IOException If an error occurs while reading the Event.
     */
    public static Event fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            Event deserializedEvent = new Event();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("count".equals(fieldName)) {
                    deserializedEvent.count = reader.getNullable(JsonReader::getInt);
                } else if ("firstTimestamp".equals(fieldName)) {
                    deserializedEvent.firstTimestamp = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("lastTimestamp".equals(fieldName)) {
                    deserializedEvent.lastTimestamp = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("name".equals(fieldName)) {
                    deserializedEvent.name = reader.getString();
                } else if ("message".equals(fieldName)) {
                    deserializedEvent.message = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedEvent.type = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedEvent;
        });
    }
}
