// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerinstance.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Image registry credential.
 */
@Fluent
public final class ImageRegistryCredential implements JsonSerializable<ImageRegistryCredential> {
    /*
     * The Docker image registry server without a protocol such as "http" and "https".
     */
    private String server;

    /*
     * The username for the private registry.
     */
    private String username;

    /*
     * The password for the private registry.
     */
    private String password;

    /*
     * The identity for the private registry.
     */
    private String identity;

    /*
     * The identity URL for the private registry.
     */
    private String identityUrl;

    /**
     * Creates an instance of ImageRegistryCredential class.
     */
    public ImageRegistryCredential() {
    }

    /**
     * Get the server property: The Docker image registry server without a protocol such as "http" and "https".
     * 
     * @return the server value.
     */
    public String server() {
        return this.server;
    }

    /**
     * Set the server property: The Docker image registry server without a protocol such as "http" and "https".
     * 
     * @param server the server value to set.
     * @return the ImageRegistryCredential object itself.
     */
    public ImageRegistryCredential withServer(String server) {
        this.server = server;
        return this;
    }

    /**
     * Get the username property: The username for the private registry.
     * 
     * @return the username value.
     */
    public String username() {
        return this.username;
    }

    /**
     * Set the username property: The username for the private registry.
     * 
     * @param username the username value to set.
     * @return the ImageRegistryCredential object itself.
     */
    public ImageRegistryCredential withUsername(String username) {
        this.username = username;
        return this;
    }

    /**
     * Get the password property: The password for the private registry.
     * 
     * @return the password value.
     */
    public String password() {
        return this.password;
    }

    /**
     * Set the password property: The password for the private registry.
     * 
     * @param password the password value to set.
     * @return the ImageRegistryCredential object itself.
     */
    public ImageRegistryCredential withPassword(String password) {
        this.password = password;
        return this;
    }

    /**
     * Get the identity property: The identity for the private registry.
     * 
     * @return the identity value.
     */
    public String identity() {
        return this.identity;
    }

    /**
     * Set the identity property: The identity for the private registry.
     * 
     * @param identity the identity value to set.
     * @return the ImageRegistryCredential object itself.
     */
    public ImageRegistryCredential withIdentity(String identity) {
        this.identity = identity;
        return this;
    }

    /**
     * Get the identityUrl property: The identity URL for the private registry.
     * 
     * @return the identityUrl value.
     */
    public String identityUrl() {
        return this.identityUrl;
    }

    /**
     * Set the identityUrl property: The identity URL for the private registry.
     * 
     * @param identityUrl the identityUrl value to set.
     * @return the ImageRegistryCredential object itself.
     */
    public ImageRegistryCredential withIdentityUrl(String identityUrl) {
        this.identityUrl = identityUrl;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (server() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property server in model ImageRegistryCredential"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(ImageRegistryCredential.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("server", this.server);
        jsonWriter.writeStringField("username", this.username);
        jsonWriter.writeStringField("password", this.password);
        jsonWriter.writeStringField("identity", this.identity);
        jsonWriter.writeStringField("identityUrl", this.identityUrl);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ImageRegistryCredential from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ImageRegistryCredential if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ImageRegistryCredential.
     */
    public static ImageRegistryCredential fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ImageRegistryCredential deserializedImageRegistryCredential = new ImageRegistryCredential();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("server".equals(fieldName)) {
                    deserializedImageRegistryCredential.server = reader.getString();
                } else if ("username".equals(fieldName)) {
                    deserializedImageRegistryCredential.username = reader.getString();
                } else if ("password".equals(fieldName)) {
                    deserializedImageRegistryCredential.password = reader.getString();
                } else if ("identity".equals(fieldName)) {
                    deserializedImageRegistryCredential.identity = reader.getString();
                } else if ("identityUrl".equals(fieldName)) {
                    deserializedImageRegistryCredential.identityUrl = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedImageRegistryCredential;
        });
    }
}
