// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerinstance.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Map;

/**
 * Container group log analytics information.
 */
@Fluent
public final class LogAnalytics implements JsonSerializable<LogAnalytics> {
    /*
     * The workspace id for log analytics
     */
    private String workspaceId;

    /*
     * The workspace key for log analytics
     */
    private String workspaceKey;

    /*
     * The log type to be used.
     */
    private LogAnalyticsLogType logType;

    /*
     * Metadata for log analytics.
     */
    private Map<String, String> metadata;

    /*
     * The workspace resource id for log analytics
     */
    private String workspaceResourceId;

    /**
     * Creates an instance of LogAnalytics class.
     */
    public LogAnalytics() {
    }

    /**
     * Get the workspaceId property: The workspace id for log analytics.
     * 
     * @return the workspaceId value.
     */
    public String workspaceId() {
        return this.workspaceId;
    }

    /**
     * Set the workspaceId property: The workspace id for log analytics.
     * 
     * @param workspaceId the workspaceId value to set.
     * @return the LogAnalytics object itself.
     */
    public LogAnalytics withWorkspaceId(String workspaceId) {
        this.workspaceId = workspaceId;
        return this;
    }

    /**
     * Get the workspaceKey property: The workspace key for log analytics.
     * 
     * @return the workspaceKey value.
     */
    public String workspaceKey() {
        return this.workspaceKey;
    }

    /**
     * Set the workspaceKey property: The workspace key for log analytics.
     * 
     * @param workspaceKey the workspaceKey value to set.
     * @return the LogAnalytics object itself.
     */
    public LogAnalytics withWorkspaceKey(String workspaceKey) {
        this.workspaceKey = workspaceKey;
        return this;
    }

    /**
     * Get the logType property: The log type to be used.
     * 
     * @return the logType value.
     */
    public LogAnalyticsLogType logType() {
        return this.logType;
    }

    /**
     * Set the logType property: The log type to be used.
     * 
     * @param logType the logType value to set.
     * @return the LogAnalytics object itself.
     */
    public LogAnalytics withLogType(LogAnalyticsLogType logType) {
        this.logType = logType;
        return this;
    }

    /**
     * Get the metadata property: Metadata for log analytics.
     * 
     * @return the metadata value.
     */
    public Map<String, String> metadata() {
        return this.metadata;
    }

    /**
     * Set the metadata property: Metadata for log analytics.
     * 
     * @param metadata the metadata value to set.
     * @return the LogAnalytics object itself.
     */
    public LogAnalytics withMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    /**
     * Get the workspaceResourceId property: The workspace resource id for log analytics.
     * 
     * @return the workspaceResourceId value.
     */
    public String workspaceResourceId() {
        return this.workspaceResourceId;
    }

    /**
     * Set the workspaceResourceId property: The workspace resource id for log analytics.
     * 
     * @param workspaceResourceId the workspaceResourceId value to set.
     * @return the LogAnalytics object itself.
     */
    public LogAnalytics withWorkspaceResourceId(String workspaceResourceId) {
        this.workspaceResourceId = workspaceResourceId;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (workspaceId() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property workspaceId in model LogAnalytics"));
        }
        if (workspaceKey() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property workspaceKey in model LogAnalytics"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(LogAnalytics.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("workspaceId", this.workspaceId);
        jsonWriter.writeStringField("workspaceKey", this.workspaceKey);
        jsonWriter.writeStringField("logType", this.logType == null ? null : this.logType.toString());
        jsonWriter.writeMapField("metadata", this.metadata, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("workspaceResourceId", this.workspaceResourceId);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of LogAnalytics from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of LogAnalytics if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the LogAnalytics.
     */
    public static LogAnalytics fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            LogAnalytics deserializedLogAnalytics = new LogAnalytics();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("workspaceId".equals(fieldName)) {
                    deserializedLogAnalytics.workspaceId = reader.getString();
                } else if ("workspaceKey".equals(fieldName)) {
                    deserializedLogAnalytics.workspaceKey = reader.getString();
                } else if ("logType".equals(fieldName)) {
                    deserializedLogAnalytics.logType = LogAnalyticsLogType.fromString(reader.getString());
                } else if ("metadata".equals(fieldName)) {
                    Map<String, String> metadata = reader.readMap(reader1 -> reader1.getString());
                    deserializedLogAnalytics.metadata = metadata;
                } else if ("workspaceResourceId".equals(fieldName)) {
                    deserializedLogAnalytics.workspaceResourceId = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedLogAnalytics;
        });
    }
}
