// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.containerinstance.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * The container execution command, for liveness or readiness probe.
 */
@Fluent
public final class ContainerExec implements JsonSerializable<ContainerExec> {
    /*
     * The commands to execute within the container.
     */
    private List<String> command;

    /**
     * Creates an instance of ContainerExec class.
     */
    public ContainerExec() {
    }

    /**
     * Get the command property: The commands to execute within the container.
     * 
     * @return the command value.
     */
    public List<String> command() {
        return this.command;
    }

    /**
     * Set the command property: The commands to execute within the container.
     * 
     * @param command the command value to set.
     * @return the ContainerExec object itself.
     */
    public ContainerExec withCommand(List<String> command) {
        this.command = command;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("command", this.command, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ContainerExec from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ContainerExec if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the ContainerExec.
     */
    public static ContainerExec fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ContainerExec deserializedContainerExec = new ContainerExec();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("command".equals(fieldName)) {
                    List<String> command = reader.readArray(reader1 -> reader1.getString());
                    deserializedContainerExec.command = command;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedContainerExec;
        });
    }
}
