/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerinstance.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerinstance.models.GpuResource;
import java.io.IOException;

public final class ResourceRequests
implements JsonSerializable<ResourceRequests> {
    private double memoryInGB;
    private double cpu;
    private GpuResource gpu;

    public double memoryInGB() {
        return this.memoryInGB;
    }

    public ResourceRequests withMemoryInGB(double memoryInGB) {
        this.memoryInGB = memoryInGB;
        return this;
    }

    public double cpu() {
        return this.cpu;
    }

    public ResourceRequests withCpu(double cpu) {
        this.cpu = cpu;
        return this;
    }

    public GpuResource gpu() {
        return this.gpu;
    }

    public ResourceRequests withGpu(GpuResource gpu) {
        this.gpu = gpu;
        return this;
    }

    public void validate() {
        if (this.gpu() != null) {
            this.gpu().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeDoubleField("memoryInGB", this.memoryInGB);
        jsonWriter.writeDoubleField("cpu", this.cpu);
        jsonWriter.writeJsonField("gpu", (JsonSerializable)this.gpu);
        return jsonWriter.writeEndObject();
    }

    public static ResourceRequests fromJson(JsonReader jsonReader) throws IOException {
        return (ResourceRequests)jsonReader.readObject(reader -> {
            ResourceRequests deserializedResourceRequests = new ResourceRequests();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("memoryInGB".equals(fieldName)) {
                    deserializedResourceRequests.memoryInGB = reader.getDouble();
                    continue;
                }
                if ("cpu".equals(fieldName)) {
                    deserializedResourceRequests.cpu = reader.getDouble();
                    continue;
                }
                if ("gpu".equals(fieldName)) {
                    deserializedResourceRequests.gpu = GpuResource.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedResourceRequests;
        });
    }
}

